% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_isobaricnormRes.R
\name{summary-isobaricnormRes}
\alias{summary-isobaricnormRes}
\alias{summary.isobaricnormRes}
\title{Summary for isobaricnormRes Object}
\usage{
\method{summary}{isobaricnormRes}(object, ...)
}
\arguments{
\item{object}{object of type isobaricnormRes, created by
\code{\link{normalize_isobaric}}}

\item{...}{further arguments passed to or from other methods.}
}
\value{
data frame object
}
\description{
For creating a summary of an S3 object of type 'isobaricnormRes'
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)
myiso <- edata_transform(omicsData = isobaric_object, data_scale = "log2")
myiso_norm <- normalize_isobaric(
  omicsData = myiso, exp_cname = "Plex",
  apply_norm = FALSE,
  refpool_cname = "Virus",
  refpool_notation = "Pool"
)
mysummary <- summary(myiso_norm)
\dontshow{\}) # examplesIf}
}
