% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trelliPlots.R
\name{trelli_abundance_heatmap}
\alias{trelli_abundance_heatmap}
\title{Heatmap trelliscope building function for abundance data}
\usage{
trelli_abundance_heatmap(
  trelliData,
  cognostics = c("sample count", "mean abundance", "biomolecule count"),
  ggplot_params = NULL,
  interactive = FALSE,
  path = .getDownloadsFolder(),
  name = "Trelliscope",
  test_mode = FALSE,
  test_example = 1,
  single_plot = FALSE,
  ...
)
}
\arguments{
\item{trelliData}{A trelliscope data object made by as.trelliData, and
grouped by an emeta variable. Required.}

\item{cognostics}{A vector of cognostic options. Defaults are "sample count", 
"mean abundance" and "biomolecule count". "sample count" and "mean abundance"
are reported per group, and "biomolecule count" is the total number of biomolecules
in the biomolecule class (e_meta column).}

\item{ggplot_params}{An optional vector of strings of ggplot parameters to
the backend ggplot function. For example, c("ylab('')", "xlab('')").
Default is NULL.}

\item{interactive}{A logical argument indicating whether the plots should be
interactive or not. Interactive plots are ggplots piped to ggplotly (for
now). Default is FALSE.}

\item{path}{The base directory of the trelliscope application. Default is
Downloads.}

\item{name}{The name of the display. Default is Trelliscope}

\item{test_mode}{A logical to return a smaller trelliscope to confirm plot
and design. Default is FALSE.}

\item{test_example}{A vector of plot indices to return for test_mode. Default
is 1.}

\item{single_plot}{A TRUE/FALSE to indicate whether 1 plot (not a
trelliscope) should be returned. Default is FALSE.}

\item{...}{Additional arguments to be passed on to the trelli builder}
}
\value{
No return value, builds a trelliscope display of heatmaps that is stored in `path`
}
\description{
Specify a plot design and cognostics for the abundance heatmap
  trelliscope. Data must be grouped by an e_meta column. Main_effects order
  the y-variables. All statRes data is ignored. For RNA-Seq data, use "trelli_rnaseq_heatmap".
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
if (interactive()) {
library(pmartRdata)

# Transform the data
omicsData <- edata_transform(omicsData = pep_object, data_scale = "log2")

# Group the data by condition
omicsData <- group_designation(omicsData = omicsData, main_effects = c("Phenotype"))

# Apply the IMD ANOVA filter
imdanova_Filt <- imdanova_filter(omicsData = omicsData)
omicsData <- applyFilt(filter_object = imdanova_Filt, omicsData = omicsData,
                       min_nonmiss_anova = 2)

# Normalize my pepData
omicsData <- normalize_global(omicsData, "subset_fn" = "all", "norm_fn" = "median",
                             "apply_norm" = TRUE, "backtransform" = TRUE)

# Implement the IMD ANOVA method and compute all pairwise comparisons 
# (i.e. leave the `comparisons` argument NULL)
statRes <- imd_anova(omicsData = omicsData, test_method = 'combined')

# Generate the trelliData object
trelliData2 <- as.trelliData(omicsData = omicsData)
trelliData4 <- as.trelliData(omicsData = omicsData, statRes = statRes)

# Build the abundance heatmap with an omicsData object with emeta variables. 
# Generate trelliData in as.trelliData.
trelli_panel_by(trelliData = trelliData2, panel = "RazorProtein") \%>\%
   trelli_abundance_heatmap(test_mode = TRUE, test_example = 1:3, path = tempdir())
   
# Users can modify the plotting function with ggplot parameters and interactivity, 
# and can also select certain cognostics.     
trelli_panel_by(trelliData = trelliData4, panel = "RazorProtein") \%>\% 
   trelli_abundance_heatmap(
     test_mode = TRUE, test_example = 1:5, 
     ggplot_params = c("ylab('')", "xlab('')"), 
     interactive = TRUE, cognostics = c("biomolecule count"),
     path = tempdir()
   )

\dontshow{closeAllConnections()}
}
}
\dontshow{\}) # examplesIf}
}
\author{
David Degnan, Lisa Bramer
}
