% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pibble.R
\name{build_pibble}
\alias{build_pibble}
\title{Low-level constructor for a pibble object}
\usage{
build_pibble(tbl, .i = NA, .t = NA, .d = 1, .uniqcheck = FALSE)
}
\arguments{
\item{.i}{Quoted variable name(s) that identify the individual cases. If this is omitted, \code{pibble} will assume the data set is a single time series.}

\item{.t}{Quoted variable name indicating the time. \code{pmdplyr} accepts two kinds of time variables: numeric variables where a fixed distance \code{.d} will take you from one observation to the next, or, if \code{.d=0}, any standard variable type with an order. Consider using the \code{time_variable()} function to create the necessary variable if your data uses a \code{Date} variable for time.}

\item{.d}{Number indicating the gap in \code{t} between one period and the next. For example, if \code{.t} indicates a single day but data is collected once a week, you might set \code{.d=7}. To ignore gap length and assume that "one period ago" is always the most recent prior observation in the data, set \code{.d=0}. By default, \code{.d=1}.}

\item{.uniqcheck}{Logical parameter. Set to TRUE to perform a check of whether \code{.i} and \code{.t} uniquely identify observations, and present a message if not. By default this is set to FALSE and the warning message occurs only once per session.}

\item{.df}{Data frame or tibble to declare as a panel.}
}
\description{
\code{build_pibble()} creates a \code{tbl_pb} object with more controls. It is useful for creating a \code{tbl_pb} internally inside a function.
}
\details{
Be aware that \code{pibble} objects store \code{.i} and \code{.t} as strings. As a low-level constructor, \code{build_pibble()} takes only character arguments for \code{.i} and \code{.t}, not unquoted variables.

For speed, \code{build_pibble()} does not check the adequacy of the inputs.
}
\keyword{internal}
