% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metar_decode.R
\name{metar_decode}
\alias{metar_decode}
\title{Decode METAR report.}
\usage{
metar_decode(x, metric = TRUE)
}
\arguments{
\item{x}{character vector; a single METAR weather report or\cr
historical METAR weather reports.}

\item{metric}{logical; if TRUE wind speeds returned in m/s, distances in meters.\cr
If FALSE, #' wind speeds returned in knots and distances in miles.}
}
\value{
a tibble with decoded METAR weather report or reports.
}
\description{
Extract and parse information from a single METAR weather report or several reports.
}
\details{
Decoded METAR weather report consists of:\cr
\itemize{
\item Remark: Don't use for flight planning or navigation!
\item Airport ICAO
\item Day of Month
\item Hour (HH:mm)
\item Time zone
\item Wind speed
\item Wind speed unit (m/s or kn)
\item Gust
\item Gust unit (m/s or kn)
\item Wind shear
\item Wind direction (degrees)
\item Temperature (Celsius degrees)
\item Dew point (Celsius degrees)
\item Pressure (hPa)
\item Visibility
\item Visibility unit (m or miles)
\item Cloud coverage
\item Weather conditions information from WX codes
\item Airport Name
\item Longitude
\item Latitude
\item Elevation
\item Decode Date
\item Original METAR text
}
}
\examples{
metar_decode("EPWA 281830Z 18009KT 140V200 9999 SCT037 03/M01 Q1008 NOSIG")
metar_decode("CYUL 281800Z 13008KT 30SM BKN240 01/M06 A3005 RMK CI5 SLP180")
metar_decode("201711271930 METAR LEMD 271930Z 02002KT CAVOK 04/M03 Q1025")

}
