% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stateEstimation.R
\name{particleFilter}
\alias{particleFilter}
\title{Fully-adapted particle filter for state estimate in a linear Gaussian state 
space model}
\usage{
particleFilter(y, theta, noParticles, initialState)
}
\arguments{
\item{y}{Observations from the model for \eqn{t=1,...,T}.}

\item{theta}{The parameters \eqn{\theta=\{\phi,\sigma_v,\sigma_e\}} of the 
LGSS model. The parameter \eqn{\phi} scales the current state in 
the state dynamics. The standard deviations of the state process noise
and the observation process noise are denoted \eqn{\sigma_v} and 
\eqn{\sigma_e}, respectively.}

\item{noParticles}{The number of particles to use in the filter.}

\item{initialState}{The initial state.}
}
\value{
The function returns a list with the elements:
\itemize{
\item{xHatFiltered: The estimate of the filtered state at time \eqn{t=1,...,T}.}
\item{logLikelihood: The estimate of the log-likelihood.}
\item{particles: The particle system at each time point.}
\item{weights: The particle weights at each time point.}
}
}
\description{
Estimates the filtered state and the log-likelihood for a linear Gaussian 
state space model of the form \eqn{ x_{t} = \phi x_{t-1} + \sigma_v v_t } 
and \eqn{ y_t = x_t + \sigma_e e_t }, where \eqn{v_t} and \eqn{e_t} denote 
independent standard Gaussian random variables, i.e.\eqn{N(0,1)}.
}
\note{
See Section 3 in the reference for more details.
}
\examples{
# Generates 500 observations from a linear state space model with
# (phi, sigma_e, sigma_v) = (0.5, 1.0, 0.1) and zero initial state.
theta <- c(0.5, 1.0, 0.1)
d <- generateData(theta, noObservations=100, initialState=0.0) 

# Estimate the filtered state using a Particle filter
pfOutput <- particleFilter(d$y, theta, noParticles = 50, 
  initialState=0.0)

# Plot the estimate and the true state
par(mfrow=c(3, 1))
plot(d$x[1:100], type="l", xlab="time", ylab="true state", bty="n", 
  col="#1B9E77")
plot(pfOutput$xHatFiltered, type="l", xlab="time", 
  ylab="paticle filter estimate", bty="n", col="#D95F02")
plot(d$x[1:100]-pfOutput$xHatFiltered, type="l", xlab="time", 
  ylab="difference", bty="n", col="#7570B3")
}
\references{
Dahlin, J. & Schön, T. B. "Getting started with particle 
Metropolis-Hastings for inference in nonlinear dynamical models." 
pre-print, arXiv:1511.01707, 2017.
}
\author{
Johan Dahlin <uni (at) johandahlin.com.nospam>
}
\keyword{ts}
