% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_naming.R
\name{affix_datetime}
\alias{affix_datetime}
\title{Put the current date-time into a file name}
\usage{
affix_datetime(
  filename,
  position = c("end", "start"),
  format = "\%Y-\%m-\%d_\%H-\%M-\%S",
  delimiter = "_",
  utc_time = TRUE,
  add_tz = FALSE
)
}
\arguments{
\item{filename}{The filename to modify.}

\item{position}{Where to place the formatted date-time. This could either be
at the \code{"end"} of the filename (the default) or at the \code{"start"}.}

\item{format}{A \code{\link[base:strptime]{base::strptime()}} format string for formatting the
date-time. By default, this is \code{"\%Y-\%m-\%dT\%H:\%M:\%S"} which expresses the
date according to the ISO 8601 standard. For example, if the current
date-time is \verb{2020-12-04 13:11:23}, the formatted string would become
\code{"2020-12-04T13:11:23"}. Refer to the documentation on \code{\link[base:strptime]{base::strptime()}}
for conversion specifications if planning to use a different format string.}

\item{delimiter}{The delimiter characters to use for separating the date-time
string from the original file name.}

\item{utc_time}{An option for whether to use the current UTC time to
establish the date-time (the default, with \code{TRUE}), or, use the system's
local time (\code{FALSE}).}

\item{add_tz}{Should the time zone (as an offset from UTC) be provided? If
\code{TRUE} then the UTC offset will be either provided as \verb{<time>Z} (if
\code{utc_time = TRUE}) or \verb{<time>(+/-)hhmm}. By default, this is \code{FALSE}.}
}
\value{
A character vector.
}
\description{
This function helps to affix the current date-time to a filename. This is
useful when writing \emph{agent} and/or \emph{informant} objects to disk as part of a
continuous process. The date-time string can be based on the current UTC time
or the local system time. The date-time can be affixed either to the end of
the filename (before the file extension) or at the beginning with a
customizable delimiter. Optionally, the time zone information can be
included. If the date-time is based on the local system time, the user system
time zone is shown with the format \verb{<time>(+/-)hhmm}. If using UTC time, then
the \verb{<time>Z} format is adopted.

The \code{\link[=x_write_disk]{x_write_disk()}}, \code{\link[=yaml_write]{yaml_write()}} functions allow for the writing of
\strong{pointblank} objects to disk. The modification of the filename string takes
effect immediately but not at the time of writing a file to disk. In most
cases, especially when using \code{affix_datetime()} with the aforementioned
file-writing functions, the file timestamps should approximate the time
components affixed to the filenames.
}
\section{Function ID}{

13-4
}

\examples{
# Taking the generic `pb_file` name for
# a file, we add the current date-time to it
# as a suffix
affix_datetime(filename = "pb_file")

# File extensions won't get in the way:
affix_datetime(filename = "pb_file.rds")

# The date-time can be used as a prefix
affix_datetime(
  filename = "pb_file",
  position = "start"
)

# The date-time pattern can be changed and so
# can the delimiter
affix_datetime(
  filename = "pb_file.yml",
  format = "\%Y\%m\%d_\%H\%M\%S",
  delimiter = "-"
)

# Time zone information can be included
affix_datetime(
  filename = "pb_file.yml",
  add_tz = TRUE
)

if (interactive()) {

# We can use a file-naming convention
# involving date-times when writing output
# files immediately after interrogating;
# useful when interrogating directly
# from YAML in a scheduled process
yaml_agent_interrogate(
  filename = system.file(
    "yaml", "agent-small_table.yml",
    package = "pointblank"
  )
) \%>\% 
  x_write_disk(
    filename = affix_datetime(
      filename = "small_table_agent.rds",
      delimiter = "-"
    ),
    keep_tbl = TRUE,
    keep_extracts = TRUE
  )

}

}
\seealso{
The \code{\link[=affix_date]{affix_date()}} function provides the same features except it
produces a date string by default.

Other Utility and Helper Functions: 
\code{\link{affix_date}()},
\code{\link{col_schema}()},
\code{\link{from_github}()},
\code{\link{has_columns}()},
\code{\link{stop_if_not}()}
}
\concept{Utility and Helper Functions}
