% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plural_forms-dataset.R
\docType{data}
\name{plural_forms}
\alias{plural_forms}
\title{Plural Forms Data}
\format{\code{plural_forms} is a data frame with 3 character columns and 1 numeric column and 142 rows:
\describe{
\item{ISO}{The ISO 639 specification of the language.  Usually this is the
two letter ISO 639-1 name, but some three letter ISO 639-2 names are also
included, for cases where no two letter name exists.}
\item{EnglishName}{How the language is known in English.}
\item{PluralFormHeader}{The GNU gettext specification of how plural forms
are specified in the language.}
\item{nplurals}{A numeric value specifying the number of plural forms.}
}}
\usage{
data(plural_forms)
}
\description{
This dataset contains the known values for the "Plural-Forms" metadata
elements in a PO file.
}
\examples{
e <- new.env()
data(plural_forms, package = "poio", envir = e)
e$plural_forms
}
\references{
This dataset was originally taken from
\url{http://localization-guide.readthedocs.org/en/latest/l10n/pluralforms.html}

ISO 639-1 (a.k.a. ISO 629-2 alpha-2) and ISO 639-2 language codes can be
found in the \code{\link[ISOcodes]{ISO_639_2}} help page, or online at
\url{http://www.loc.gov/standards/iso639-2/php/code_list.php}
}
\keyword{datasets}

