% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/waldCI.r
\name{waldCI}
\alias{waldCI}
\title{Compute the Wald confidence interval}
\usage{
waldCI(data, N1, N2, N01, N02, conf.level = 0.95)
}
\arguments{
\item{data}{the vector of counts of the fallible data (z11, z12, z21, z22) followed by the infallible data (m011, m012, m021, m022, y01, y02)}

\item{N1}{the opportunity size of group 1 for the fallible data}

\item{N2}{the opportunity size of group 2 for the fallible data}

\item{N01}{the opportunity size of group 1 for the infallible data}

\item{N02}{the opportunity size of group 2 for the infallible data}

\item{conf.level}{confidence level of the interval}
}
\value{
a named vector containing the lower and upper bounds of the confidence interval
}
\description{
Compute the Wald confidence interval of a two-sample Poisson rate with misclassified data given fallible and infallible datasets.
}
\examples{
\dontrun{

# small example
z11 <- 34; z12 <- 35; N1 <- 10;
z21 <- 22; z22 <- 31; N2 <- 10;
m011 <- 9; m012 <- 1; y01 <- 3; N01 <- 3;
m021 <- 8; m022 <- 8; y02 <- 2; N02 <- 3;
data <- c(z11, z12, z21, z22, m011, m012, m021, m022, y01, y02)

waldCI(data, N1, N2, N01, N02)
margMLECI(data, N1, N2, N01, N02)
profMLECI(data, N1, N2, N01, N02)
approxMargMLECI(data, N1, N2, N01, N02)


# big example :
z11 <- 477; z12 <- 1025; N1 <- 16186;
z21 <- 255; z22 <- 1450; N2 <- 18811;
m011 <- 38;  m012 <- 90; y01 <- 15; N01 <- 1500;
m021 <- 41; m022 <- 200; y02 <-  9; N02 <- 2500;
data <- c(z11, z12, z21, z22, m011, m012, m021, m022, y01, y02)

waldCI(data, N1, N2, N01, N02)
margMLECI(data, N1, N2, N01, N02)
profMLECI(data, N1, N2, N01, N02)
approxMargMLECI(data, N1, N2, N01, N02)


}
}

