% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poker.R
\name{dotScorer}
\alias{dotScorer}
\title{dotScorer}
\usage{
dotScorer(cardsRow)
}
\arguments{
\item{cardsRow}{: \tabular{ll}{one 7 card hand as
vector[14] \tab  \cr \tab
col1: rank of card 1 in \{2, ... , 14\} \cr \tab
col2: suit of card 1 in \{1, 2, 3, 4\} \cr \tab
col3: rank of card 2 \cr \tab
col4: suit of card 2 \cr \tab
. \cr \tab
. \cr \tab
. \cr \tab
col13: rank of card 7 \cr \tab
col14: suit of card 7}}
}
\value{
\tabular{ll}{ranking : the rank of the hand as
											integer in \{2, ... , 9\} \tab \cr \tab
											 9 = Straight Flush \cr \tab
											 8 = Four of a Kind \cr \tab
											 7 = Full House \cr \tab
											 6 = Flush \cr \tab
											 5 = Straight \cr \tab
											 4 = Three of a Kind \cr \tab
											 3 = Two Pair \cr \tab
											 2 = One Pair \cr \tab
											 1 = High Card}
}
\description{
Determine the ranking of one hand.
}
\examples{
dotScorer(c(2,1,3,2,5,3,6,4,7,1,13,2,14,2))
dotScorer(c(2,1,2,2,5,3,6,4,7,1,13,2,14,2))
dotScorer(c(2,1,2,2,5,3,5,4,7,1,13,2,14,2))
dotScorer(c(2,1,2,2,2,3,5,4,7,1,13,2,14,2))
dotScorer(c(2,1,3,2,4,3,5,4,6,1,13,2,14,2))
dotScorer(c(2,1,3,1,5,1,6,1,7,1,13,2,14,2))
dotScorer(c(2,1,2,2,2,8,13,8,7,1,13,2,14,2))
dotScorer(c(2,1,2,2,2,3,2,4,7,1,13,2,14,2))
dotScorer(c(2,1,3,1,4,1,5,1,6,1,7,1,14,2))
}
\seealso{
\code{\link{dotTransformToNumber}}, \code{\link{dotTransformToRank}}
}
