% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{gen_data_mapl}
\alias{gen_data_mapl}
\title{Example data generating process from Offline Multi-Action Policy Learning: Generalization and Optimization}
\usage{
gen_data_mapl(n, p = 10, sigma2 = 4)
}
\arguments{
\item{n}{Number of observations \eqn{X}.}

\item{p}{Number of features (minimum 7). Default is 10.}

\item{sigma2}{Noise variance. Default is 4.}
}
\value{
A list with realized action \eqn{a_i}, region \eqn{r_i},
conditional mean \eqn{\mu}, outcome \eqn{Y} and covariates \eqn{X}
}
\description{
The DGP from section 6.4.1 in Zhou, Athey, and Wager (2023):
There are \eqn{d=3} actions \eqn{(a_0,a_1,a_2)} which depend
on 3 regions the covariates \eqn{X \sim U[0,1]^p} reside in. Observed outcomes:
\eqn{Y \sim N(\mu_{a_i}(X_i), 4)}
}
\references{
Zhou, Zhengyuan, Susan Athey, and Stefan Wager. "Offline multi-action policy learning:
Generalization and optimization." Operations Research 71.1 (2023).
}
