% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_01_apps.R
\name{get_apps}
\alias{get_apps}
\title{Polished API - Get App(s)}
\usage{
get_apps(app_uid = NULL, app_name = NULL, api_key = get_api_key())
}
\arguments{
\item{app_uid}{an optional app uid.}

\item{app_name}{an optional app name.}

\item{api_key}{your Polished API key.  Set your polished api key using \code{\link{set_api_key}()}
so that you do not need to supply this argument with each function call.}
}
\value{
an object of class \code{polished_api_res}.  The \code{content} of the object is a
tibble of app(s) with the following columns:
\itemize{
\item \code{uid}
\item \code{app_name}
\item \code{app_url}
\item \code{created_at}
\item \code{modified_at}
}
}
\description{
Polished API - Get App(s)
}
\details{
If both the \code{app_uid} and \code{app_name} are \code{NULL}, then all the
apps in your account will be returned.  If either \code{app_uid} or \code{app_name} are not
\code{NULL}, then a single app will be returned (assuming the app exists).  If both the
\code{app_uid} and \code{app_name} are provided, then the \code{app_uid} will be used,
and the \code{app_name} will be ignored.  If the app does not exists, a zero row tibble
will be returned.
}
\seealso{
\code{\link[=add_app]{add_app()}} \code{\link[=update_app]{update_app()}} \code{\link[=delete_app]{delete_app()}}
}
