% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policy_data_functions.R
\name{get_stage_action_sets}
\alias{get_stage_action_sets}
\title{Get Stage Action Sets}
\usage{
get_stage_action_sets(object)
}
\arguments{
\item{object}{Object of class \link{policy_data}.}
}
\value{
List of character vectors.
}
\description{
\code{get_stage_action_sets} returns the action sets at each stage, i.e.,
the possible actions at each stage for the policy data object.
}
\examples{
### Two stages:
d <- sim_two_stage_multi_actions(5e2, seed=1)
# constructing policy_data object:
pd <- policy_data(d,
                  action = c("A_1", "A_2"),
                  baseline = c("B"),
                  covariates = list(L = c("L_1", "L_2"),
                                    C = c("C_1", "C_2")),
                  utility = c("U_1", "U_2", "U_3"))
pd

# getting the stage actions set:
get_stage_action_sets(pd)
}
