% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/charts.R
\name{pollstr_charts}
\alias{pollstr_charts}
\title{Get list of available charts}
\usage{
pollstr_charts(topic = NULL, state = NULL, showall = NULL,
  convert = TRUE)
}
\arguments{
\item{topic}{Only include charts related to a specific topic. See \url{http://elections.huffingtonpost.com/pollster/api} for examples.}

\item{state}{Only include charts from a single state. Use 2-letter state abbreviations. "US" will return all national charts.}

\item{showall}{logical Include charts for races that were once possible but didn't happen (e.g. Gingrich vs. Obama 2012)}

\item{convert}{Rearrange the data returned by the API into easier to use data frames.}
}
\value{
If \code{convert=TRUE}, a \code{"pollstr_charts"} object with elements
\describe{
  \item{\code{charts}}{Data frame with data on charts.}
  \item{\code{estimates}}{Data frame with current estimates from each chart. The column \code{slug} matches this data frame to \code{charts}}
}
Otherwise, a \code{"list"} in the original structure of the json returned by the API.
}
\description{
Get list of available charts
}
\examples{
\dontrun{
 # Get charts related to Washington
 wa <- pollstr_charts(state='WA')
 # Get national charts
 us_charts <- pollstr_charts(state='US')
 # Get charts in the topic '2016-president'
 gov <- pollstr_charts(topic='2016-president')
 # Get all charts
 allcharts <- pollstr_charts()
}
}
\references{
\url{http://elections.huffingtonpost.com/pollster/api}
}

