% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moeCrosstab.R
\name{moe_crosstab}
\alias{moe_crosstab}
\title{weighted crosstabs with margin of error}
\usage{
moe_crosstab(
  df,
  x,
  y,
  weight,
  remove = c(""),
  n = TRUE,
  pct_type = "row",
  format = "long",
  zscore = 1.96
)
}
\arguments{
\item{df}{The data source}

\item{x}{The independent variable}

\item{y}{The dependent variable}

\item{weight}{The weighting variable, defaults to zwave_weight}

\item{remove}{An optional character vector of values to remove from final table (e.g. "refused").
This will not affect any calculations made. The vector is not case-sensitive.}

\item{n}{logical, if TRUE numeric totals are included.}

\item{pct_type}{Controls the kind of percentage values returned. One of "row" or "cell."
Column percents are not supported.}

\item{format}{one of "long" or "wide"}

\item{zscore}{defaults to 1.96, consistent with a 95\% confidence interval}
}
\value{
a tibble
}
\description{
\code{moe_crosstab} returns a tibble containing a weighted crosstab of two variables with margin of error
}
\details{
Options  include row or cell percentages. The tibble can be in long or wide format. The margin of
 error includes the design effect of the weights.
}
\examples{
moe_crosstab(df = illinois, x = voter, y = raceethnic, weight = weight)
moe_crosstab(df = illinois, x = voter, y = raceethnic, weight = weight, n = FALSE)
}
