% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.DocumentTermMatrix_method.R
\docType{methods}
\name{as.TermDocumentMatrix}
\alias{as.DocumentTermMatrix}
\alias{as.DocumentTermMatrix,bundle-method}
\alias{as.DocumentTermMatrix,partitionBundle-method}
\alias{as.TermDocumentMatrix}
\alias{as.TermDocumentMatrix,bundle-method}
\alias{as.TermDocumentMatrix,character-method}
\alias{as.TermDocumentMatrix,partitionBundle-method}
\title{as.TermDocumentMatrix / as.DocumentTermMatrix}
\usage{
as.TermDocumentMatrix(x, ...)

\S4method{as.TermDocumentMatrix}{character}(x, pAttribute, sAttribute,
  from = NULL, to = NULL, strucs = NULL, rmBlank = TRUE,
  verbose = TRUE, robust = FALSE, mc = FALSE)

\S4method{as.TermDocumentMatrix}{bundle}(x, col, pAttribute = NULL,
  verbose = TRUE)

\S4method{as.DocumentTermMatrix}{bundle}(x, col)

\S4method{as.TermDocumentMatrix}{partitionBundle}(x, pAttribute = NULL,
  col = NULL, verbose = TRUE)

\S4method{as.DocumentTermMatrix}{partitionBundle}(x, pAttribute = NULL,
  col = NULL, verbose = TRUE)
}
\arguments{
\item{x}{some object}

\item{...}{to make the check happy}

\item{pAttribute}{the p-attribute}

\item{sAttribute}{the s-attribute}

\item{from}{bla}

\item{to}{bla}

\item{strucs}{bla}

\item{rmBlank}{bla}

\item{verbose}{bla}

\item{robust}{bla}

\item{mc}{logical}

\item{col}{the column to use of assembling the matrix}
}
\value{
a TermDocumentMatrix
}
\description{
Method for type conversion, to generate the classes
\code{"TermDocumentMatrix"} or \code{"DocumentTermMatrix"} contained in the
\code{"tm"} package. The classes inherit from the
\code{"simple_triplet_matrix"}-class defined in the \code{"slam"}-package. A
\code{"DocumentTermMatrix"} is required as input by the \code{"topicmodels"}
package, for instance.
}
\details{
The type conversion-method can be applied on object of the class
\code{"bundle"}, or classes inheriting from the \code{"bundle"} class. If
counts or some other measure is present in the \code{"stat"} slots of the
objects in the bundle, then the values in the column indicated by
\code{"col"} will be turned into the values of the sparse matrix that is
generated. A special case is the generation of the sparse matrix based on a
\code{"partitionBundle"} that does not yet include counts. In this case, a 
\code{"pAttribute"} needs to be provided, then counting will be performed,
too.
}
\examples{
if (require(polmineR.sampleCorpus) && require(rcqp)){
   use("polmineR.sampleCorpus")
   p <- partition("PLPRBTTXT", text_date=".*", regex=TRUE)
   pB <- partitionBundle(p, def=list(text_date=NULL))
   pB <- enrich(pB, pAttribute="word")
   tdm <- as.TermDocumentMatrix(pB, col="count")
   
   pB2 <- partitionBundle(p, def=list(text_date=NULL))
   tdm <- as.TermDocumentMatrix(pB2, pAttribute="word")
}
}
\author{
Andreas Blaette

me
}

