% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sAttributes_method.R
\docType{methods}
\name{sAttributes,character-method}
\alias{sAttributes,character-method}
\alias{sAttributes,partition-method}
\alias{sAttributes}
\alias{sAttributes,character-method}
\title{Get s-attributes.}
\usage{
\S4method{sAttributes}{character}(.Object, sAttribute = NULL, unique = TRUE,
  regex = NULL)

\S4method{sAttributes}{partition}(.Object, sAttribute = NULL, unique = TRUE)
}
\arguments{
\item{.Object}{either a \code{partition} object or a character vector specifying a CWB corpus}

\item{sAttribute}{name of a specific s-attribute}

\item{unique}{logical, whether to return unique values only}

\item{regex}{filter return value by applying a regex}
}
\value{
a character vector
}
\description{
Structural annotations (s-attributes) of a corpus provide metainformation for
regions of tokens. Gain access to the s-attributes available for a corpus or partition,
or the values of s-attributes in a corpus/partition with the \code{sAttributes}-method.
}
\details{
Importing XML into the Corpus Workbench (CWB) turns elements and element
attributes into so-called s-attributes. There are two uses of the sAttributes-method: If the 
\code{sAttribute} parameter is NULL (default), the return value is a character vector
with all s-attributes present in a corpus.

If sAttribute is the name of a specific s-attribute (a length 1 character vector), the
values of the s-attributes available in the corpus/partition are returned.

If a character vector of s-attributes is provided, the method will return a \code{data.table}.
}
\examples{
  use("polmineR")
  
  sAttributes("GERMAPARLMINI")
  sAttributes("GERMAPARLMINI", "date") # dates of plenary meetings
  
  
  P <- partition("GERMAPARLMINI", date = "2009-11-10")
  sAttributes(P)
  sAttributes(P, "speaker") # get names of speakers
}
