% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernels.R
\name{eff_kern}
\alias{eff_kern}
\alias{b_d}
\alias{v_d}
\title{Polyspherical kernel moments and efficiencies}
\usage{
eff_kern(d, r, k = 10, kernel, kernel_type = c("prod", "sph")[1],
  kernel_ref = "2", kernel_ref_type = c("prod", "sph")[2], ...)

b_d(kernel, d, k = 10, kernel_type = c("prod", "sph")[1], ...)

v_d(kernel, d, k = 10, kernel_type = c("prod", "sph")[1], ...)
}
\arguments{
\item{d}{a scalar with the common dimension of each hypersphere
\eqn{\mathcal{S}^d}.}

\item{r}{a scalar with the number of polyspheres of the same dimension.}

\item{k}{softplus kernel parameter. Defaults to \code{10.0}.}

\item{kernel}{kernel employed: \code{1} for von Mises--Fisher (default);
\code{2} for Epanechnikov; \code{3} for softplus.}

\item{kernel_type}{type of kernel. Must be either \code{"prod"} (product
kernel, default) or \code{"sph"} (spherically symmetric kernel).}

\item{kernel_ref}{reference kernel to which compare the efficiency. Uses the
same codification as the \code{kernel}. Defaults to \code{"2"}.}

\item{kernel_ref_type}{type of the reference kernel. Must be either
\code{"prod"} (product kernel) or \code{"sph"} (spherically symmetric kernel,
default).}

\item{...}{further arguments passed to \code{\link{integrate}}, such as
\code{upper}, \code{abs.tol}, \code{rel.tol}, etc.}
}
\value{
\itemize{
\item{\code{b_d}: a vector with the first kernel moment on each hypersphere
(common if \code{kernel_type = "sph"}).}
\item{\code{v_d}: a vector with the second kernel moment if
\code{kernel_type = "prod"}, or a scalar if \code{kernel_type = "sph"}.}
\item{\code{eff_kern}: a scalar with the kernel efficiency.}
}
}
\description{
Computes moments of kernels on \eqn{\mathcal{S}^{d_1} \times
\cdots \times \mathcal{S}^{d_r}} and efficiencies of kernels on
\eqn{(\mathcal{S}^d)^r}.
}
\examples{
# Kernel moments
b_d(kernel = 2, d = c(2, 3), kernel_type = "prod")
v_d(kernel = 2, d = c(2, 3), kernel_type = "prod")
b_d(kernel = 2, d = c(2, 3), kernel_type = "sph")
v_d(kernel = 2, d = c(2, 3), kernel_type = "sph")

# Kernel efficiencies
eff_kern(d = 2, r = 1, kernel = "1")
eff_kern(d = 2, r = 1, kernel = "2")
eff_kern(d = 2, r = 1, k = 10, kernel = "3")
}
