% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{test_prefpairing}
\alias{test_prefpairing}
\title{Check for and estimate preferential pairing}
\usage{
test_prefpairing(dosage_matrix, maplist, LG_hom_stack,
  target_parent = "P1", other_parent = "P2", ploidy, min_cM = 0.5,
  adj.method = "fdr", verbose = TRUE)
}
\arguments{
\item{dosage_matrix}{An integer matrix with markers in rows and individuals in columns.}

\item{maplist}{A list of integrated chromosomal maps, as generated by e.g. \code{\link{MDSMap_from_list}}. In the first column marker names and in the second their position.}

\item{LG_hom_stack}{A \code{data.frame} with markernames (\code{"SxN_Marker"}), linkage group (\code{"LG"}) and homologue (\code{"homologue"}),
the output of \code{\link{define_LG_structure}} or \code{\link{bridgeHomologues}} usually.}

\item{target_parent}{Character string specifying the parent to be tested for preferential pairing as provided in the columnnames of dosage_matrix, by default "P1".}

\item{other_parent}{The other parent, by default "P2"}

\item{ploidy}{The ploidy level of the species, by default 4 (tetraploid) is assumed.}

\item{min_cM}{The smallest distance to be considered a true distance on the linkage map, by default distances less than 0.5 cM are considered essentially zero.}

\item{adj.method}{Method to correct p values of Binomial test for multiple testing, by default the FDR correction is used, other options are available, inherited from \code{\link{p.adjust}}}

\item{verbose}{Should messages be send to stdout? If \code{NULL} log is send to stdout.}
}
\description{
Identify closely-mapped repulsion-phase simplex x nulliplex markers and test these
for preferential pairing, including estimating a preferential pairing parameter.
}
\examples{
data("ALL_dosages","integrated.maplist","LGHomDf_P1_1")
P1pp <- test_prefpairing(ALL_dosages,integrated.maplist,LGHomDf_P1_1,ploidy=4)
}
