% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{createTetraOriginInput}
\alias{createTetraOriginInput}
\title{Create input files for TetraOrigin using an integrated linkage map list and marker dosage matrix}
\usage{
createTetraOriginInput(
  maplist,
  dosage_matrix,
  bin_size = NULL,
  bounds = NULL,
  remove_markers = NULL,
  outdir = "TetraOrigin",
  output_stem = "TetraOrigin_input",
  plot_maps = TRUE,
  log = NULL
)
}
\arguments{
\item{maplist}{A list of maps. In the first column marker names and in the second their position.}

\item{dosage_matrix}{An integer matrix with markers in rows and individuals in columns. Either provide the unconverted dosages (i.e.
before using the \code{\link{convert_marker_dosages}} function), or converted dosages (i.e. screened data), in matrix form.
The analysis and results are unaffected by this choice, but it may be simpler to understand the results if converted dosages
are used. Conversely, it may be advantageous to use the original unconverted dosages if particular marker alleles are being
tracked for (e.g.) the development of selectable markers afterwards.}

\item{bin_size}{Numeric. Size (in cM) of the bins to include. If \code{NULL} (by default) then all markers are used (no binning).}

\item{bounds}{Numeric vector. If \code{NULL} (by default) then all positions are included, however if specified then output
is limited to a specific region, which is useful for later fine-mapping work.}

\item{remove_markers}{Optional vector of marker names to remove from the maps. Default is \code{NULL}.}

\item{outdir}{Output directory to which input files for TetraOrigin are written.}

\item{output_stem}{Character prefix to add to the .csv output filename.}

\item{plot_maps}{Logical. Plot the marker positions of the selected markers using \code{\link{plot_map}}.}

\item{log}{Character string specifying the log filename to which standard output should be written. If NULL log is send to stdout.}
}
\description{
\code{createTetraOriginInput} is a function for creating an input file for TetraOrigin, combining
map positions with marker dosages.
}
\examples{
\dontrun{
data("integrated.maplist","ALL_dosages")
createTetraOriginInput(maplist=integrated.maplist,dosage_matrix=ALL_dosages,bin_size=10)}
}
