% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_write_POMDP.R
\name{write_POMDP}
\alias{write_POMDP}
\alias{read_POMDP}
\title{Read and write a POMDP Model to a File in POMDP Format}
\usage{
write_POMDP(x, file, digits = 7)

read_POMDP(file, parse = TRUE, normalize = TRUE)
}
\arguments{
\item{x}{an object of class \link{POMDP}.}

\item{file}{a file name. \code{read_POMDP()} also accepts \link{connections} including URLs.}

\item{digits}{precision for writing numbers (digits after the decimal
point).}

\item{parse}{logical; try to parse the model matrices.
Solvers still work with unparsed matrices, but helpers for simulation are not available.}

\item{normalize}{logical; should the description be normalized for faster access (see \code{\link[=normalize_POMDP]{normalize_POMDP()}})?}
}
\value{
\code{read_POMDP()} returns a \link{POMDP} object.
}
\description{
Reads and write a POMDP file suitable for the \code{pomdp-solve} program.
}
\details{
\link{POMDP} objects read from a POMDP file have an extra element called \code{problem} which contains the original
POMDP specification. \strong{The original specification is directly used by external solvers.} In addition, the file
is parsed using an experimental POMDP file parser. The parsed information can be used with auxiliary functions
in this package that use fields like the transition matrix, the observation matrix and the reward structure.

\strong{Notes:}
The parser for POMDP files is experimental. Please report
problems here: \url{https://github.com/mhahsler/pomdp/issues}.
}
\examples{
data(Tiger)

## show the POMDP file that would be written.
write_POMDP(Tiger, file = stdout())
}
\references{
POMDP solver website: https://www.pomdp.org
}
\seealso{
Other POMDP: 
\code{\link{POMDP_accessors}},
\code{\link{POMDP}()},
\code{\link{plot_belief_space}()},
\code{\link{projection}()},
\code{\link{regret}()},
\code{\link{sample_belief_space}()},
\code{\link{simulate_POMDP}()},
\code{\link{solve_POMDP}()},
\code{\link{solve_SARSOP}()},
\code{\link{transition_graph}()},
\code{\link{update_belief}()},
\code{\link{value_function}()}
}
\author{
Hossein Kamalzadeh, Michael Hahsler
}
\concept{POMDP}
\keyword{IO}
