% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spect.R, R/spect_match.R, R/objfun.R
\docType{methods}
\name{spect}
\alias{spect}
\alias{spect,missing-method}
\alias{spect,ANY-method}
\alias{spect-data.frame}
\alias{spect,data.frame-method}
\alias{spect-pomp}
\alias{spect,pomp-method}
\alias{spect-spectd_pomp}
\alias{spect,spectd_pomp-method}
\alias{spect-spect_match_objfun}
\alias{spect,spect_match_objfun-method}
\alias{coerce-spect_match_objfun-spectd_pomp}
\alias{coerce,spect_match_objfun,spectd_pomp-method}
\alias{spect-objfun}
\alias{spect,objfun-method}
\title{Power spectrum}
\usage{
\S4method{spect}{data.frame}(data, vars, kernel.width, nsim, seed = NULL,
  transform.data = identity, detrend = c("none", "mean", "linear",
  "quadratic"), params, rinit, rprocess, rmeasure, ...,
  verbose = getOption("verbose", FALSE))

\S4method{spect}{pomp}(data, vars, kernel.width, nsim, seed = NULL,
  transform.data = identity, detrend = c("none", "mean", "linear",
  "quadratic"), ..., verbose = getOption("verbose", FALSE))

\S4method{spect}{spectd_pomp}(data, vars, kernel.width, nsim,
  seed = NULL, transform.data, detrend, ...,
  verbose = getOption("verbose", FALSE))

\S4method{spect}{spect_match_objfun}(data, seed, ...,
  verbose = getOption("verbose", FALSE))

\S4method{spect}{objfun}(data, seed = NULL, ...)
}
\arguments{
\item{data}{either a data frame holding the time series data,
or an object of class \sQuote{pomp},
i.e., the output of another \pkg{pomp} calculation.}

\item{vars}{optional; names of observed variables for which the power spectrum will be computed.
By default, the spectrum will be computed for all observables.}

\item{kernel.width}{width parameter for the smoothing kernel used for
calculating the estimate of the spectrum.}

\item{nsim}{number of model simulations to be computed.}

\item{seed}{optional; if non-\code{NULL}, the random number generator will
be initialized with this seed for simulations.
See \code{\link[=simulate-pomp]{simulate}}.}

\item{transform.data}{function; this transformation will be applied to the
observables prior to estimation of the spectrum, and prior to any
detrending.}

\item{detrend}{de-trending operation to perform.  Options include no
detrending, and subtraction of constant, linear, and quadratic trends from
the data.  Detrending is applied to each data series and to each model
simulation independently.}

\item{params}{optional; named numeric vector of parameters.
This will be coerced internally to storage mode \code{double}.}

\item{rinit}{simulator of the initial-state distribution.
This can be furnished either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
Setting \code{rinit=NULL} sets the initial-state simulator to its default.
For more information, see \link[=rinit_spec]{?rinit_spec}.}

\item{rprocess}{simulator of the latent state process, specified using one of the \link[=rprocess_spec]{rprocess plugins}.
Setting \code{rprocess=NULL} removes the latent-state simulator.
For more information, \link[=rprocess_spec]{see ?rprocess_spec for the documentation on these plugins}.}

\item{rmeasure}{simulator of the measurement model, specified either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
Setting \code{rmeasure=NULL} removes the measurement model simulator.
For more information, see \link[=rmeasure_spec]{?rmeasure_spec}.}

\item{...}{additional arguments supply new or modify existing model characteristics or components.
See \code{\link{pomp}} for a full list of recognized arguments.

When named arguments not recognized by \code{\link{pomp}} are provided, these are made available to all basic components via the so-called \dfn{userdata} facility.
This allows the user to pass information to the basic components outside of the usual routes of covariates (\code{covar}) and model parameters (\code{params}).
See \link[=userdata]{?userdata} for information on how to use this facility.}

\item{verbose}{logical; if \code{TRUE}, diagnostic messages will be printed to the console.}
}
\value{
An object of class \sQuote{spectd_pomp}, which contains the model, the data, and the results of the \code{spect} computation.
The following methods are available:
\describe{
\item{plot}{produces some diagnostic plots}
\item{summary}{displays a summary}
\item{logLik}{gives a measure of the agreement of the power spectra}
}
}
\description{
Power spectrum computation and spectrum-matching for partially-observed
Markov processes.
}
\details{
\code{spect} estimates the power spectrum of time series data and model
simulations and compares the results.  It can be used to diagnose goodness
of fit and/or as the basis for frequency-domain parameter estimation
(\code{spect.match}).

A call to \code{spect} results in the estimation of the power spectrum for
the (transformed, detrended) data and \code{nsim} model simulations.  The
results of these computations are stored in an object of class
\sQuote{spectd_pomp}.

When \code{spect} operates on a spectrum-matching objective function (a \sQuote{spect_match_objfun} object), by default, the
random-number generator seed is fixed at the value given when the objective function was constructed.
Specifying \code{NULL} or an integer for \code{seed} overrides this behavior.
}
\references{
D.C. Reuman, R.A. Desharnais, R.F. Costantino, O. Ahmad, J.E.
Cohen (2006) Power spectra reveal the influence of stochasticity on
nonlinear population dynamics.  \emph{Proceedings of the National Academy
of Sciences} \bold{103}, 18860-18865.

D.C. Reuman, R.F. Costantino, R.A. Desharnais, J.E. Cohen (2008) Color of
environmental noise affects the nonlinear dynamics of cycling,
stage-structured populations.  \emph{Ecology Letters}, \bold{11}, 820-830.
}
\seealso{
Other summary statistics methods: \code{\link{abc}},
  \code{\link{basic_probes}}, \code{\link{probe.match}},
  \code{\link{probe}}

Other elementary POMP methods: \code{\link{pfilter}},
  \code{\link{pomp-package}}, \code{\link{probe}},
  \code{\link{simulate}}
}
\author{
Daniel C. Reuman, Cai GoGwilt, Aaron A. King
}
\concept{elementary POMP methods}
\concept{summary statistics methods}
