% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmcmc.R
\name{pmcmc}
\alias{pmcmc}
\alias{pmcmc,ANY-method}
\alias{pmcmc,missing-method}
\alias{pmcmc,data.frame-method}
\alias{pmcmc,pomp-method}
\alias{pmcmc,pfilterd_pomp-method}
\alias{pmcmc,pmcmcd_pomp-method}
\title{The particle Markov chain Metropolis-Hastings algorithm}
\usage{
\S4method{pmcmc}{data.frame}(
  data,
  Nmcmc = 1,
  proposal,
  Np,
  params,
  rinit,
  rprocess,
  dmeasure,
  dprior,
  ...,
  verbose = getOption("verbose", FALSE)
)

\S4method{pmcmc}{pomp}(
  data,
  Nmcmc = 1,
  proposal,
  Np,
  ...,
  verbose = getOption("verbose", FALSE)
)

\S4method{pmcmc}{pfilterd_pomp}(
  data,
  Nmcmc = 1,
  proposal,
  Np,
  ...,
  verbose = getOption("verbose", FALSE)
)

\S4method{pmcmc}{pmcmcd_pomp}(data, Nmcmc, proposal, ..., verbose = getOption("verbose", FALSE))
}
\arguments{
\item{data}{either a data frame holding the time series data,
or an object of class \sQuote{pomp},
i.e., the output of another \pkg{pomp} calculation.
Internally, \code{data} will be internally coerced to an array with storage-mode \code{double}.}

\item{Nmcmc}{The number of PMCMC iterations to perform.}

\item{proposal}{optional function that draws from the proposal
distribution.  Currently, the proposal distribution must be symmetric for
proper inference: it is the user's responsibility to ensure that it is.
Several functions that construct appropriate proposal function are
provided: see \link[=proposals]{MCMC proposals} for more information.}

\item{Np}{the number of particles to use.
This may be specified as a single positive integer, in which case the same number of particles will be used at each timestep.
Alternatively, if one wishes the number of particles to vary across timesteps, one may specify \code{Np} either as a vector of positive integers of length \preformatted{length(time(object,t0=TRUE))} or as a function taking a positive integer argument.
In the latter case, \code{Np(k)} must be a single positive integer, representing the number of particles to be used at the \code{k}-th timestep:
\code{Np(0)} is the number of particles to use going from \code{timezero(object)} to \code{time(object)[1]},
\code{Np(1)}, from \code{timezero(object)} to \code{time(object)[1]},
and so on,
while when \code{T=length(time(object))}, \code{Np(T)} is the number of particles to sample at the end of the time-series.}

\item{params}{optional; named numeric vector of parameters.
This will be coerced internally to storage mode \code{double}.}

\item{rinit}{simulator of the initial-state distribution.
This can be furnished either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
Setting \code{rinit=NULL} sets the initial-state simulator to its default.
For more information, see \link[=rinit specification]{rinit specification}.}

\item{rprocess}{simulator of the latent state process, specified using one of the \link[=rprocess specification]{rprocess plugins}.
Setting \code{rprocess=NULL} removes the latent-state simulator.
For more information, see \link[=rprocess specification]{rprocess specification for the documentation on these plugins}.}

\item{dmeasure}{evaluator of the measurement model density, specified either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
Setting \code{dmeasure=NULL} removes the measurement density evaluator.
For more information, see \link[=dmeasure specification]{dmeasure specification}.}

\item{dprior}{optional; prior distribution density evaluator, specified either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
For more information, see \link[=prior specification]{prior specification}.
Setting \code{dprior=NULL} resets the prior distribution to its default, which is a flat improper prior.}

\item{...}{additional arguments supply new or modify existing model characteristics or components.
See \code{\link{pomp}} for a full list of recognized arguments.

When named arguments not recognized by \code{\link{pomp}} are provided, these are made available to all basic components via the so-called \dfn{userdata} facility.
This allows the user to pass information to the basic components outside of the usual routes of covariates (\code{covar}) and model parameters (\code{params}).
See \link[=userdata]{userdata} for information on how to use this facility.}

\item{verbose}{logical; if \code{TRUE}, diagnostic messages will be printed to the console.}
}
\value{
An object of class \sQuote{pmcmcd_pomp}.
}
\description{
The Particle MCMC algorithm for estimating the parameters of a
partially-observed Markov process.  Running \code{pmcmc} causes a particle
random-walk Metropolis-Hastings Markov chain algorithm to run for the
specified number of proposals.
}
\section{Methods}{

The following can be applied to the output of a \code{pmcmc} operation:
\describe{
\item{\code{pmcmc}}{repeats the calculation, beginning with the last state}
\item{\code{\link{continue}}}{continues the \code{pmcmc} calculation}
\item{\code{plot}}{produces a series of diagnostic plots}
\item{\code{\link{filter.traj}}}{extracts a random sample from the smoothing distribution}
\item{\code{\link{traces}}}{produces an \code{\link[coda]{mcmc}} object, to which the various \pkg{coda} convergence diagnostics can be applied}
}
}

\section{Re-running PMCMC Iterations}{

To re-run a sequence of PMCMC
iterations, one can use the \code{pmcmc} method on a \sQuote{pmcmc} object.
By default, the same parameters used for the original PMCMC run are re-used
(except for \code{verbose}, the default of which is shown above).  If one
does specify additional arguments, these will override the defaults.
}

\section{Note for Windows users}{


Some Windows users report problems when using C snippets in parallel computations.
These appear to arise when the temporary files created during the C snippet compilation process are not handled properly by the operating system.
To circumvent this problem, use the \code{\link[=pomp]{cdir}} and \code{\link[=pomp]{cfile}} options to cause the C snippets to be written to a file of your choice, thus avoiding the use of temporary files altogether.
}

\references{
\Andrieu2010
}
\seealso{
More on \pkg{pomp} estimation algorithms:
\code{\link{approximate Bayesian computation}},
\code{\link{bsmc2}()},
\code{\link{estimation algorithms}},
\code{\link{mif2}()},
\code{\link{nonlinear forecasting}},
\code{\link{pomp-package}},
\code{\link{probe matching}},
\code{\link{spectrum matching}}

More on sequential Monte Carlo methods: 
\code{\link{bsmc2}()},
\code{\link{cond.logLik}()},
\code{\link{eff.sample.size}()},
\code{\link{filter.mean}()},
\code{\link{filter.traj}()},
\code{\link{kalman}},
\code{\link{mif2}()},
\code{\link{pfilter}()},
\code{\link{pred.mean}()},
\code{\link{pred.var}()},
\code{\link{saved.states}()},
\code{\link{wpfilter}()}

More on full-information (i.e., likelihood-based) methods:
\code{\link{bsmc2}()},
\code{\link{mif2}()},
\code{\link{pfilter}()},
\code{\link{wpfilter}()}

More on Markov chain Monte Carlo methods:
\code{\link{approximate Bayesian computation}},
\code{\link{proposals}}

More on Bayesian methods:
\code{\link{approximate Bayesian computation}},
\code{\link{bsmc2}()},
\code{\link{dprior}()},
\code{\link{prior specification}},
\code{\link{rprior}()}
}
\author{
Edward L. Ionides, Aaron A. King, Sebastian Funk
}
\concept{Bayesian methods}
\concept{MCMC methods}
\concept{estimation methods}
\concept{full-information methods}
\concept{particle filter methods}
