##' pre-built pomp examples
##'
##' Examples of pomp objects containing models and data.
##'
##' @name pomp_examples
##' @rdname pomp_examp
##' @docType data
##' @keywords models
##' @family pomp examples
##' @details
##' \pkg{pomp} includes a number of pre-built examples of pomp objects and data that can be analyzed using \pkg{pomp} methods.
##' These include:
##' \describe{
##' \item{\code{\link{blowflies}}}{Data from Nicholson's experiments with sheep blowfly populations}
##' \item{\code{\link{blowflies1}()}}{A pomp object with some of the blowfly data together with a discrete delay equation model.}
##' \item{\code{\link{blowflies2}()}}{A variant of \code{blowflies1}.}
##' \item{\code{\link{bsflu}}}{Data from an outbreak of influenza in a boarding school.}
##' \item{\code{\link{dacca}()}}{Fifty years of census and cholera mortality data, together with a stochastic differential equation transmission model (King et al. 2008).}
##' \item{\code{\link{ebolaModel}()}}{Data from the 2014 West Africa outbreak of Ebola virus disease, together with simple transmission models (King et al. 2015).}
##' \item{\code{\link{gompertz}()}}{The Gompertz population dynamics model, with simulated data.}
##' \item{\code{\link{LondonYorke}}}{Data on incidence of several childhood diseases (London and Yorke 1973)}
##' \item{\code{\link{ewmeas}}}{Measles incidence data from England and Wales}
##' \item{\code{\link{ewcitmeas}}}{Measles incidence data from 7 English cities}
##' \item{\code{\link{ou2}()}}{A 2-D Ornstein-Uhlenbeck process with simulated data}
##' \item{\code{\link{parus}}}{Population censuses of a \emph{Parus major} population in Wytham Wood, England.}
##' \item{\code{\link{ricker}}}{The Ricker population dynamics model, with simulated data}
##' \item{\code{\link{rw2}}}{A 2-D Brownian motion model, with simulated data.}
##' \item{\code{\link{sir}()}}{A simple continuous-time Markov chain SIR model, coded using Euler-multinomial steps, with simulated data.}
##' \item{\code{\link{sir2}()}}{A simple continuous-time Markov chain SIR model, coded using Gillespie's algorithm, with simulated data.}
##' \item{\code{\link{verhulst}()}}{The Verhulst-Pearl (logistic) model, a continuous-time model of population dynamics, with simulated data}
##' }
##' 
##' See also the tutorials on the \href{https://kingaa.github.io/pomp/}{package website} for more examples.
##' 
##' @references
##'
##' \Anonymous1978
##'
##' \King2008
##'
##' \King2015
##'
##' \London1973
##' 
##' \Nicholson1957
##'
NULL
