% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_import.R
\name{fsa_batch_imp}
\alias{fsa_batch_imp}
\title{Batch Import of .fsa files}
\usage{
fsa_batch_imp(
  folder,
  channels = NULL,
  fourier = TRUE,
  saturated = TRUE,
  lets.pullup = FALSE,
  plotting = FALSE,
  rawPlot = FALSE,
  llength = 3000,
  ulength = 80000
)
}
\arguments{
\item{folder}{The path to the folder from the current directory where the
.fsa files that will be analyzed are stored.}

\item{channels}{The number of dye channels expected, including the ladder.}

\item{fourier}{True/False Should fourier transformation be applied.}

\item{saturated}{True/False whether to Check and correct for saturated peaks.}

\item{lets.pullup}{True/False Applying pull up correction to the samples to
decrease noise from channel to channel. The default is FALSE, please do not
change this.}

\item{plotting}{True/False Should plots be drawn of all channels after data
cleaning.}

\item{rawPlot}{True/False indicating whether a plot should be drawn of all
vectors.}

\item{llength}{A numeric value for the minimum number of indexes in each
channel.}

\item{ulength}{A numeric value for the maximum number fo indexes in each
channel.}
}
\value{
Output is a LIST where each element of the list is a DATAFRAME with
the channels in columns for each FSA file
}
\description{
This function imports and extracts all of the information out of the .fsa
files and combines them into one list type object.\code{fsa_batch_imp} is a
modification of the original Fragman import script function, \code{storing.inds},
This revised script accommodates ABI's .fsa file format up to version 3.
It retains Fragman functions for Fourier transformation, saturated peaks,
and pull-up correction. Notable adjustments include updating channel
parameters, utilizing Dyechannel count from the file directory, and
streamlining the script by extracting data only from "DATA" tags.
Major changes involve column selection for v3 formats and modifications to
the "channel" parameter. Minor changes include allowing relative paths for
the data directory, importing only .fsa files, and renaming channels with
dye names. This revision ensures successful execution for any format version
up to 3.
}
\examples{
file_path <- system.file("extdata", package = "pooledpeaks")
fsa_batch_imp(file_path, channels = 5, fourier = FALSE, saturated = FALSE ,
lets.pullup = FALSE,plotting = FALSE, rawPlot = FALSE)
}
