% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poolcushion_t.R
\name{poolcushion_t}
\alias{poolcushion_t}
\title{Visualize T-test Power for Pooling Design as Function of Processing Error
Variance}
\usage{
poolcushion_t(g = NULL, n = NULL, d = NULL, mu1 = NULL,
  mu2 = NULL, sigsq = NULL, sigsq1 = sigsq, sigsq2 = sigsq,
  sigsq_p_predicted = 0, sigsq_p_range = NULL, sigsq_m = 0,
  multiplicative = FALSE, alpha = 0.05, beta = 0.2, labels = TRUE)
}
\arguments{
\item{g}{Numeric value specifying the pool size.}

\item{n}{Numeric value specifying the number of assays per group. If
unspecified, function figures out \code{n} required for
100 (1 - \code{beta})\% power when \code{sigsq_p = 0}.}

\item{d}{Numeric value specifying true difference in group means.}

\item{mu1, mu2}{Numeric value specifying group means. Required if
\code{multiplicative = TRUE}.}

\item{sigsq}{Numeric value specifying the variance of observations.}

\item{sigsq1, sigsq2}{Numeric value specifying the variance of observations
for each group.}

\item{sigsq_p_predicted}{Numeric value specifying predicted processing error
variance. Used to calculate \code{n} if \code{n} is unspecified.}

\item{sigsq_p_range}{Numeric vector specifying range of processing error
variances to consider.}

\item{sigsq_m}{Numeric value specifying the variance of measurement errors.}

\item{multiplicative}{Logical value for whether to assume multiplicative
rather than additive errors.}

\item{alpha}{Numeric value specifying type-1 error rate.}

\item{beta}{Numeric value specifying type-2 error rate. Only used if
\code{n = NULL}.}

\item{labels}{Logical value.}
}
\value{
Plot generated by \code{\link[ggplot2]{ggplot}}.
}
\description{
Useful for choosing a sample size such that power will be adequate even if
the processing errors are larger than anticipated.
}
\examples{
# Determine optimal pool size and number of assays to detect a difference in
# group means of 0.5, with a common variance of 1, processing errors with
# variance of 0.1, and measurement errors with variance of 0.2. Assume costs
# of $100 per assay and $10 per subject.
poolcost_t(
  g = 1: 10,
  d = 0.5,
  sigsq = 1,
  sigsq_p = 0.1,
  sigsq_m = 0.2,
  assay_cost = 100,
  other_costs = 10
)

# Visualize how power of the study will be affected if the true processing
# error variance is not exactly 0.1.
poolcushion_t(
  g = 7,
  n = 29,
  d = 0.5,
  sigsq = 1,
  sigsq_p_predicted = 0.1,
  sigsq_m = 0.2
)


}
