% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-funs.R
\name{plot_series}
\alias{plot_series}
\title{Plot original vs converted counts}
\usage{
plot_series(series, title = TRUE, path = ".", path_fig = ".", save = FALSE)
}
\arguments{
\item{series}{a \code{character} string. The count series names (can be
retrieved by running \code{\link[=list_series]{list_series()}}).}

\item{title}{a \code{logical}. If \code{TRUE} (default) a title (series name) is
added.}

\item{path}{a \code{character} string. The directory in which count series have
been saved by the function \code{\link[=format_data]{format_data()}}.}

\item{path_fig}{a \code{character} string. The directory where to save the plot
(if \code{save = TRUE}). This directory must exist and can be an absolute or a
relative path.}

\item{save}{a \code{logical}. If \code{TRUE} (default is \code{FALSE}) the plot is saved in
\code{path_fig}.}
}
\value{
No return value.
}
\description{
This function plots a panel of two graphics for one count series
(previously generated by \code{\link[=format_data]{format_data()}}):
\itemize{
\item on the left side, scatter plot overlapping original (black points) and
converted counts (grey points);
\item on the right side, scatter plot of converted counts with boundaries of the
95\% confident interval.
}
}
\examples{
## Load Garamba raw dataset ----
file_path <- system.file("extdata", "garamba_survey.csv", 
                         package = "popbayes")
                         
garamba <- read.csv(file = file_path)

## Create temporary folder ----
temp_path <- tempdir()

## Format dataset ----
garamba_formatted <- popbayes::format_data(
  data              = garamba, 
  path              = temp_path,
  field_method      = "field_method",
  pref_field_method = "pref_field_method",
  conversion_A2G    = "conversion_A2G",
  rmax              = "rmax")

## Get series names ----
popbayes::list_series(path = temp_path)

## Plot for Alcelaphus buselaphus at Garamba ----
popbayes::plot_series("garamba__alcelaphus_buselaphus", path = temp_path)
}
