\name{stage.vector.plot}
\alias{stage.vector.plot}

\title{ Plot stage vector projections }
\description{
 Plots short-term dynamics and convergence to stage stage distribution using stage vector projections.  
}
\usage{
stage.vector.plot(stage.vectors, proportions=TRUE, legend.coords="topright", 
        ylim=NULL, xlab="Years", ylab=NULL, col=rainbow(8),  ... )
}
 
\arguments{
  \item{stage.vectors}{ a matrix listing stage class vectors in columns}
  \item{proportions}{ plot proportional changes or total numbers, defaults to proportions. }
  \item{legend.coords}{ a \code{\link{legend}} keyword or vector of x,y coordinates, defaults to top-right corner }
  \item{ylim}{the y limits of the plot, defaults to min and max values in stage.vectors}
  \item{xlab}{a label for the x axis}
  \item{ylab}{a label for the y axis}
  \item{col}{Vector of color names for line drawings.  Default is rainbow(8)}
 
  \item{...}{additional options are passed to \code{\link{plot}} function}


}
\details{   A plot of stage or age class projections }
\references{see section 2.2 in Caswell 2001 }
\author{ Chris Stubben }

\seealso{ see \code{\link{pop.projection}} }
\examples{

## matrix from Example 2.1 in Caswell
A<-matrix(c(
0, 0.3,   0,
1,   0, 0.5,
5,   0,   0
), nrow=3, dimnames=list(1:3,1:3))
n<-c(1,0,0)
p<-pop.projection(A,n,60)

## Plots in Figure 2.3
stage.vector.plot(p$stage.vector[,1:15], col='black', las=1, prop=FALSE)
stage.vector.plot(p$stage.vector[,1:40], col=2:4, las=1)
## log-scale with custom y-axis
stage.vector.plot(p$stage.vector, col=2:4, prop=FALSE,
ylim=c(.01, 10), log='y', legend="bottomright", yaxt='n')
pwrs<- -2:1
# major ticks
axis(2, at = 10^pwrs, labels=parse(text=paste("10^", pwrs, sep = "")),
las=1, tcl= -.8)
# minor ticks
axis(2, at = 1:9 * rep(10^pwrs[-1] / 10, each = 9),
    tcl = -0.4, labels = FALSE)

}
\keyword{ survey }
