% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaaMLGclass.R
\docType{class}
\name{MLG-class}
\alias{MLG-class}
\alias{MLG}
\title{MLG class}
\description{
A class to store multilocus genotypes in genclone objects. This is intended
for internal use only.
}
\section{Slots}{

\describe{
\item{\code{mlg}}{a list containing four vectors, one for each type of MLG 
manipulation.}

\item{\code{visible}}{a character specifying which MLG type is to be displayed and 
accessed.}

\item{\code{distname}}{the name of the distance function or matrix used to collapse 
mlgs.}

\item{\code{distargs}}{the arguments provided to compute the distance function.}

\item{\code{distalgo}}{the algorithm used to contract multilocus genotypes.}

\item{\code{cutoff}}{Two numbers specifying the cutoff value for expanding and 
collapsing MLGs.}
}}

\examples{

# These examples will simply show you what you can do with these
set.seed(5000)
(x <- sample(10, 20, replace = TRUE))
(m <- new("MLG", x))

 visible(m) # original is always default
 
 m[]       # adding braces after the object will always return a vector of 
           # the same type as defined in "visible"
           
 m + 1     # You can do math on the numeric ones
 
 visible(m) <- "custom"
 m + 2     # This should throw a warning
 # The types are stored in a data frame. You can retrieve them easily:
 visible(m) <- "original"
 m
 m[, "custom"]
 
 # Important for subsetting, if you subset the object, normally, it will 
 # return a vector unless you specify all = TRUE
 m[1:10]             # original vector
 m[1:10, all = TRUE] # still class MLG

}
\seealso{
\code{\linkS4class{genclone}} \code{\linkS4class{snpclone}}
  \code{\link{mll}} For developers: \code{\link{visible}}
}
\author{
Zhian N. Kamvar
}
\keyword{internal}
