% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backtestSummary.R
\name{backtestSummary}
\alias{backtestSummary}
\title{Summary of portfolio backtest}
\usage{
backtestSummary(bt, portfolio_indexes = NA, portfolio_names = NA,
  summary_fun = median, show_benchmark = TRUE)
}
\arguments{
\item{bt}{Backtest results as produced by the function \code{\link{portfolioBacktest}}.}

\item{portfolio_indexes}{Numerical vector of portfolio indexes whose performance will be summarized, 
e.g., \code{c(1, 2)} means to summarize the performance of the first and 
second portfolios recorded in \code{bt}.}

\item{portfolio_names}{String vector of portfolio names whose performance will be summarized, 
e.g., \code{c("Uniform", "GMVP")} means to summarize the performance of portfolios
with names \code{"Uniform"} and \code{"GMVP"} in \code{bt} (default is 
\code{names(bt)} except the benchmark names). Only considered when 
\code{portfolio_indexes} is not passed.}

\item{summary_fun}{Summary function to be employed (e.g., \code{median} or \code{mean}).}

\item{show_benchmark}{Logical value indicating whether to include benchmarks in the summary (default is \code{TRUE}).}
}
\value{
List with the following elements:
\item{\code{performance_summary}}{Performance criteria: 
                \code{"Sharpe ratio"}, \code{"max drawdown"}, \code{"annual return"}, \code{"annual volatility"}, 
                \code{"Sterling ratio"}, \code{"Omega ratio"}, and \code{"ROT bps"}.
                 Default is \code{"Sharpe ratio"}.}
\item{\code{failure_rate}}{Failure rate of each portfolio (failure is when the portfolio
                           function generates an error or the maximum CPU time is exceeded).}
\item{\code{cpu_time_summary}}{Summary of the CPU usage by each portfolio function.}
\item{\code{error_message}}{Error messages generated by each portfolio function over each dataset.
                            Useful for debugging purposes.}
}
\description{
Summarize the results from a portfolio backtest.
}
\examples{
library(portfolioBacktest)
data(dataset10)  # load dataset

# define your own portfolio function
uniform_portfolio <- function(dataset) {
  N <- ncol(dataset$adjusted)
  return(rep(1/N, N))
}

# do backtest
bt <- portfolioBacktest(list("Uniform" = uniform_portfolio), dataset10)

# show the summary
bt_sum <- backtestSummary(bt)
names(bt_sum)
bt_sum$performance_summary

}
\author{
Rui Zhou and Daniel P. Palomar
}
