% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repair_draws.R
\name{repair_draws}
\alias{repair_draws}
\alias{repair_draws.draws_matrix}
\alias{repair_draws.draws_array}
\alias{repair_draws.draws_df}
\alias{repair_draws.draws_list}
\alias{repair_draws.draws_rvars}
\alias{repair_draws.rvar}
\title{Repair indices of \code{draws} objects}
\usage{
repair_draws(x, order = TRUE, ...)

\method{repair_draws}{draws_matrix}(x, order = TRUE, ...)

\method{repair_draws}{draws_array}(x, order = TRUE, ...)

\method{repair_draws}{draws_df}(x, order = TRUE, ...)

\method{repair_draws}{draws_list}(x, order = TRUE, ...)

\method{repair_draws}{draws_rvars}(x, order = TRUE, ...)

\method{repair_draws}{rvar}(x, order = TRUE, ...)
}
\arguments{
\item{x}{(draws) A \code{draws} object or another \R object for which the method
is defined.}

\item{order}{(logical) Should draws be ordered (via \code{\link[=order_draws]{order_draws()}}) before
repairing indices? Defaults to \code{TRUE}.}

\item{...}{Arguments passed to individual methods (if applicable).}
}
\value{
A \code{draws} object of the same class as \code{x}.
}
\description{
Repair indices of \code{draws} objects so that iterations, chains, and draws
are continuously and consistently numbered.
}
\examples{
x <- as_draws_array(example_draws())
(x <- x[10:5, 3:4, ])
repair_draws(x)

}
\seealso{
\code{\link[=order_draws]{order_draws()}}
}
