% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\name{merge.powdRlib}
\alias{merge.powdRlib}
\title{Merge two powdRlib objects}
\usage{
\method{merge}{powdRlib}(x, y, ...)
}
\arguments{
\item{x}{a \code{powdRlib} object.}

\item{y}{a \code{powdRlib} object}

\item{...}{other arguments}
}
\value{
a \code{powdRlib} object.
}
\description{
\code{merge.powdRlib} allows two \code{powdRlib} objects (which must have) the
same 2theta scale) to be merged into a single powdRlib object.
}
\examples{
#Load the minerals library
data(minerals)

#Load the rockjock library
data(rockjock)

#interpolate minerals library onto same 2theta as rockjock
minerals_i <- interpolate(minerals, new_tth = rockjock$tth)

#merge the libraries
merged_lib <- merge(rockjock, minerals_i)
}
