% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{dist_rand}
\alias{dist_rand}
\alias{dist_rand,conpl-method}
\alias{dist_rand,disexp-method}
\alias{dist_rand,dislnorm-method}
\alias{dist_rand,displ-method}
\title{Random number generation for the distribution objects}
\usage{
dist_rand(m, n)

\S4method{dist_rand}{conpl}(m, n = "numeric")

\S4method{dist_rand}{disexp}(m, n = "numeric")

\S4method{dist_rand}{dislnorm}(m, n = "numeric")

\S4method{dist_rand}{displ}(m, n = "numeric")
}
\arguments{
\item{m}{a distribution reference object.}

\item{n}{number of observations to be generated.}
}
\value{
n random numbers
}
\description{
This is generic function for generating random numbers
from the underlying distribution of the distribution reference objects.
This function generates \code{n} random numbers using the parameters
and xmin values found in the associated reference object.
}
\note{
This method does *not* alter the internal state of
the distribubtion object. This method is only available for
discrete and continuous power law objects.
}
\examples{
##########################################
#Create distribution object              #
##########################################
m = displ$new()
m$setXmin(7);m$setPars(2)

##########################################
#Generate five random numbers            #
##########################################
dist_rand(m, 5)
}
\seealso{
\code{\link{dist_cdf}}, \code{\link{dist_pdf}}
and \code{\link{dist_ll}}
}

