% Generated by roxygen2 (4.0.1): do not edit by hand
\name{bootstrap}
\alias{bootstrap}
\alias{bootstrap_p}
\alias{estimate_xmin}
\alias{get_KS_statistic}
\title{Estimating the lower bound (xmin)}
\usage{
bootstrap(m, xmins = 1e+05, pars = NULL, no_of_sims = 100, threads = 1)

bootstrap_p(m, xmins = 1e+05, pars = NULL, no_of_sims = 100,
  threads = 1)

get_KS_statistic(m)

estimate_xmin(m, xmins = 1e+05, pars = NULL)
}
\arguments{
\item{m}{A reference class object that contains the data.}

\item{pars}{default \code{NULL}. A vector of parameters used to
optimise over.
Otherwise, for each value of \code{xmin}, the mle will be used, i.e. \code{estimate_pars(m)}.
For small samples, the mle may be biased.}

\item{xmins}{default \code{1e5}. A vector of possible values
of xmin to explore. When a single value is passed, this represents
the maximum value to search, i.e. by default we search from
(1, 1e5). See details for further information.}

\item{threads}{number of concurrent threads used during the bootstrap.}

\item{no_of_sims}{number of bootstrap simulations. When \code{no_of_sims} is large, this can
take a while to run.}
}
\description{
When fitting heavy tailed distributions, sometimes it
is necessary to estimate the lower threshold, xmin. The
lower bound is estimated by calculating the minimising the
Kolmogorov-Smirnoff statistic
(as described in Clauset, Shalizi, Newman (2009)).
\describe{
\item{\code{get_KS_statistic}}{Calculates the KS statistic for a particular value of xmin}
\item{\code{estimate_xmin}}{Estimates the optimal lower cutoff using a
goodness-of-fit based approach. This function may issue \code{warnings}
when fitting lognormal, Poisson or Exponential distributions. The
warnings occur for large values of \code{xmin}. Essentially, we are discarding
the bulk of the distribution and cannot calculate the tails to enough
accuracy.}
\item{\code{bootstrap}}{Estimates the unncertainity in the xmin and parameter values via bootstraping.}
\item{\code{bootstrap_p}}{Performs a bootstrapping hypothesis test to determine whether a power law
distribution is plausible. This function only available for power law distribution objects.}}
}
\details{
When estimating \code{xmin}
for discrete distributions, the search space when
comparing the data-cdf (empirical cdf)
and the distribution_cdf runs from 1 to \code{max(x)}
where \code{x} is the data set. This \strong{can} often be
computationally brutal. In particular, when bootstrapping
we generate random numbers from the power law distribution,
which has a long tail.

To speed up computations for discrete distributions, it is sensible to put an
upper bound or explicitly give values of where to search.
If a single value is used in \code{xmins}, this will be used
as the maximum search space value.
If \code{length(xmins) > 1}, this will explicitly
define the search space.
}
\note{
Adapted from Laurent Dubroca's code found at
\url{http://tuvalu.santafe.edu/~aaronc/powerlaws/plfit.r}
}
\examples{
###################################################
# Load the data set and create distribution object#
###################################################
x = 1:10
m = displ$new(x)

###################################################
# Estimate xmin and pars                          #
###################################################
est = estimate_xmin(m)
m$setXmin(est)

###################################################
# Bootstrap examples                              #
###################################################
bootstrap(m, no_of_sims=1, threads=1)
bootstrap_p(m, no_of_sims=1, threads=1)
}

