% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missing_data.R
\name{get_dropout}
\alias{get_dropout}
\alias{get_dropout.plcp_multi}
\title{Get the amount of dropout}
\usage{
get_dropout(object, ...)

\method{get_dropout}{plcp_multi}(object, n = 1, ...)
}
\arguments{
\item{object}{An object created by \code{\link{study_parameters}}}

\item{...}{Optional arguments.}

\item{n}{The \emph{n}-th dataset to use for objects with multiple designs.}
}
\value{
A \code{data.frame} with the proportion of dropout per time point
and treatment condition.
}
\description{
Get the amount of dropout
}
\examples{
p <- study_parameters(n1 = 11,
                      n2 = 5,
                      n3 = 6,
                      T_end = 10,
                      icc_pre_subject = 0.5,
                      icc_pre_cluster = 0,
                      var_ratio = 0.03,
                      icc_slope = 0.05,
                      dropout = dropout_weibull(proportion = 0.3, rate = 3),
                      cohend = -0.8)
get_dropout(p)
}
\seealso{
\code{\link{dropout_manual}}, \code{\link{dropout_weibull}}
}
