% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crt.long.cont.R
\name{crt.long.cont}
\alias{crt.long.cont}
\title{Power for test of treatment effect in longitudinal cluster randomized trial with baseline measurement}
\usage{
crt.long.cont(
  m = NULL,
  J1 = NULL,
  J.ratio = 1,
  delta = NULL,
  sd = 1,
  icc = 0,
  cac = 0,
  sac = 0,
  alpha = 0.05,
  power = NULL,
  sides = 2,
  v = FALSE
)
}
\arguments{
\item{m}{The number of subjects measured during each cluster-period.}

\item{J1}{The number of clusters in arm 1.}

\item{J.ratio}{The ratio J2/J1 between the number of clusters in the two arms; defaults to 1 (equal clusters per arm).}

\item{delta}{The difference between the intervention and control means under the alternative minus the difference under the null hypothesis.}

\item{sd}{The total standard deviation of the outcome variable; defaults to 1.}

\item{icc}{The within-cluster, within-period intraclass correlation coefficient; defaults to 0.}

\item{cac}{The cluster autocorrelation; defaults to 0.}

\item{sac}{The subject autocorrelation; defaults to 0.}

\item{alpha}{The significance level (type 1 error rate); defaults to 0.05.}

\item{power}{The specified level of power.}

\item{sides}{Either 1 or 2 (default) to specify a one- or two- sided hypothesis test.}

\item{v}{Either TRUE for verbose output or FALSE (default) to output computed argument only.}
}
\value{
A list of the arguments (including the computed one).
}
\description{
This function computes power and sample size for a cluster randomized trial in which a continuous
outcome variable is measured during both baseline and follow-up periods among
the cluster members, and it is planned that the outcome data will be analyzed using
a linear mixed model in which the dependent variable vector includes both baseline and follow up
measurements and there is a random intercept for cluster.
This function can solve for power, J1, J.ratio, m or delta.
}
\details{
The intraclass correlation coefficient (icc) is the correlation between
two observations from different subjects in the same cluster and same time period.
Denote the correlation between observations from two
different subjects in the same cluster but different time periods as iccb.
The cluster autocorrelation (cac) is iccb/icc and is interpreted as the proportion of
the cluster-level variance that is time-invariant.
Denote the correlation between two observations from the same subject
in different time periods as rhoa.
The subject autocorrelation (sac) is (rhoa - icc)/(iccb - icc) and is interpreted as
the proportion of the subject-level variance that is time-invariant.
The sac is only relevant for design in which the same subjects are measured at both baseline and follow up.
If different subjects are measured during different time periods, sac should be set to zero.
}
\examples{
crt.long.cont(m = 30, J1 = 8, delta = 0.3, icc = 0.05, cac = 0.4, sac = 0.5)
}
