% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGeoRates.R
\name{plotGeoRatesCon}
\alias{plotGeoRatesCon}
\title{plotGeoRatesCon}
\usage{
plotGeoRatesCon(geo_center, geo_size, time_int, trees, path="")
}
\arguments{
\item{geo_center}{change in geographic center of suitable climate envelope}

\item{geo_size}{change in geographic size of suitable climate envelope}

\item{time_int}{time intervals to plot}

\item{trees}{distribution of phylogenies}

\item{path}{path to the directory where the results to be saved}
}
\value{
plots of geo rate
}
\description{
plotGeoRatesCon
}
\details{
Creates plot with gray background of all pairwise comparisons of change in geo center and area through time. Blue points on top show the sequential change in geo center and expansion/contraction for all lineages
}
\examples{
data(sampletrees)
data(occurrences)
tree <- sampletrees[[25]]
\donttest{occurrences <- getBioclimVars(occurrences, which.biovars=1)
sp_data_min<- tapply(occurrences[,4],occurrences$Species,min)
sp_data_max<- tapply(occurrences[,4],occurrences$Species,max)
treedata_min <- geiger::treedata(tree,sp_data_min,sort=TRUE,warnings=F)
treedata_max <- geiger::treedata(tree,sp_data_max,sort=TRUE,warnings=F)
full_est <- nodeEstimateEnvelopes(treedata_min,treedata_max)
node_est <- full_est$est
example_getEnvelopes <- getEnvelopes(treedata_min, treedata_max, node_est)
example_getGeoRate <- getGeoRate(example_getEnvelopes, tree,which.biovars=1)
}
\dontrun{plotGeoRatesCon(example_getGeoRate$geo_center,example_getGeoRate$geo_size,
example_getGeoRate$time_int, trees = trees[[1]], path=tempdir())}
}
\seealso{
\code{getGeoRates}
}
\author{
A. Michelle Lawing, Alexandra F. C. Howard
}
