% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_data.R
\docType{data}
\name{ppiUGA2022}
\alias{ppiUGA2022}
\title{Poverty Probability Index (PPI) lookup table for Uganda 2022}
\format{
A data frame with 21 columns and 100 rows:
\describe{
\item{\code{score}}{PPI score}
\item{\code{ppp100}}{Below $1.00 per day purchasing power parity (2011)}
\item{\code{ppp190}}{Below $1.90 per day purchasing power parity (2011)}
\item{\code{ppp320}}{Below $3.20 per day purchasing power parity (2011)}
\item{\code{ppp550}}{Below $5.50 per day purchasing power parity (2011)}
\item{\code{ppp800}}{Below $8.00 per day purchasing power parity (2011)}
\item{\code{ppp1100}}{Below $11.00 per day purchasing power parity (2011)}
\item{\code{ppp1500}}{Below $15.00 per day purchasing power parity (2011)}
\item{\code{ppp2170}}{Below $21.70 per day purchasing power parity (2011)}
\item{\code{percentile20}}{Below 20th percentile poverty line}
\item{\code{percentile40}}{Below 40th percentile poverty line}
\item{\code{percentile60}}{Below 50th percentile poverty line}
\item{\code{percentile80}}{Below 60th percentile poverty line}
}
}
\source{
\url{https://www.povertyindex.org}
}
\usage{
ppiUGA2022
}
\description{
Poverty Probability Index (PPI) lookup table for Uganda 2022
}
\examples{
  # Access Uganda PPI table
  ppiUGA2022

  # Given a specific PPI score (from 0 - 100), get the row of poverty
  # probabilities from PPI table it corresponds to
  ppiScore <- 50
  ppiUGA2022[ppiUGA2022$score == ppiScore, ]

  # Use subset() function to get the row of poverty probabilities corresponding
  # to specific PPI score
  ppiScore <- 50
  subset(ppiUGA2022, score == ppiScore)

  # Given a specific PPI score (from 0 - 100), get a poverty probability
  # based on a specific poverty definition. In this example, the purchasing
  # power parity at $1.00
  ppiScore <- 50
  ppiUGA2022[ppiUGA2022$score == ppiScore, "ppp100"]

}
\keyword{datasets}
