% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tgplot.R
\name{tgplot}
\alias{tgplot}
\title{Plot TextGrid}
\usage{
tgplot(
  tg,
  t,
  sr,
  start,
  tiers = 1,
  tfrom0 = TRUE,
  tierNames = TRUE,
  alignment = "central",
  specialChar = FALSE,
  color = "black"
)
}
\arguments{
\item{tg}{TextGrid object loaded using \link[rPraat:tg.read]{rPraat::tg.read}}

\item{t}{Numeric vector giving times corresponding to the signal.}

\item{sr}{Integer giving the sampling rate of the signal.}

\item{start}{Start time (in seconds) of desired plotted area.}

\item{tiers}{Vector of number or strings giving either numeric identifiers
of TextGrid tiers to plot or the names of TextGrid tiers to plot. Default is
\code{1}, which plots just the first tier.}

\item{tfrom0}{Logical; should time on the x-axis run from 0 or from the
original time? Default is \code{TRUE}.}

\item{tierNames}{Logical; should TextGrid tier names be printed along the
y-axis? Default is \code{TRUE}.}

\item{alignment}{String giving the desired alignment of text in the
TextGrids. Default is \code{central}; other options are \code{left} and \code{right}.
Alternatively, a vector of strings if different alignments are needed.}

\item{specialChar}{Logical; should Praat typesetting for special font types
such as italic, bold, and small caps be converted into corresponding
R-readable special font types. Default is \code{FALSE}, since special characters
can create unfortunate text alignment artefacts.
See https://www.fon.hum.uva.nl/praat/manual/Text_styles.html.}

\item{color}{String or vector of strings giving the name of the color(s)
to be used for the text in TextGrids. Default is \code{'black'}. If a vector is
provided, different colors are used for different tiers.}
}
\value{
No return values, called internally by \link{praatpicture} and sibling
functions.
}
\description{
Function for plotting TextGrids called by \link{praatpicture}. Instead of using
this function directly, just use
\code{praatpicture('my_sound_file', frames='TextGrid')}.
}
\examples{
# Don't use directly
datapath <- system.file('extdata', package='praatpicture')
soundFile <- paste0(datapath, '/1.wav')
praatpicture(soundFile, frames='TextGrid')
}
