% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mantel_comparison_to_base.R
\name{mantel_comparison_to_base}
\alias{mantel_comparison_to_base}
\title{Ensemble Mantel Tests}
\usage{
mantel_comparison_to_base(distance_matrices, names = NULL,
  permutations = 1000, base_dfm_index = 128, text_size = 1,
  return_values = FALSE)
}
\arguments{
\item{distance_matrices}{A list of document distance matrices from th3
`$distance_matrices` field of the output from the `scaling_comparison()`
function.}

\item{names}{Optional argument giving names for each preprocessing step.}

\item{permutations}{The number of permutations to be used in each Mantel
test. Defaults to 1000.}

\item{base_dfm_index}{Which dfm should be used as a base case for comparing
r statistics with bootstrapped confidence intervals.}

\item{text_size}{The `cex` for the x-labels, defaults to 1.}

\item{return_values}{Logical indicating whether test statistics and
confidence bounds should be returned as a data.frame or not. Defaults to FALSE.}
}
\value{
A data.frame with mantel statistics and 95 percent confidence
intervals comparing all other preprocessing choices to base case, and/or a
plot of confidence intervals.
}
\description{
Calculates Mantel test statistics for differences between
distance matrices for a list of distance matrices (one per preprocessing
method) supplied by the scaling_comparison() function to a base case --
(usually the no-preprocessing specification).
}
\examples{
\dontrun{
# load the package
library(preText)
# load in the data
data("UK_Manifestos")
# preprocess data
preprocessed_documents <- factorial_preprocessing(
    UK_Manifestos,
    use_ngrams = TRUE,
    infrequent_term_threshold = 0.02,
    verbose = TRUE)
# scale documents
scaling_results <- scaling_comparison(preprocessed_documents$dfm_list,
                                      dimensions = 2,
                                      distance_method = "cosine",
                                      verbose = TRUE)
# run mantel comparison to base and plot
mantel_comparison_to_base(scaling_results$distance_matrices,
                          names = preprocessed_documents$labels,
                          permutations = 1000)
}
}
