% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/as.fd.r
\name{as.fd}
\alias{as.fd}
\alias{as.precintcon.fd}
\alias{precintcon.fd}
\title{Frequency distribution of a precipitation serie}
\usage{
as.precintcon.fd(object, interval = 1)
}
\arguments{
\item{object}{a daily precipitation serie.}

\item{interval}{the interval in millimeters for calculating the frequency
distribution.}
}
\value{
A data.frame (precintcon.fd) containing the following variables:
\itemize{
\item \code{initial.class} is the initial value of the class.
\item \code{final.class} is the final value of the class.
\item \code{midpoint} is the middle point of the class.
\item \code{n} is the absolute freqnecy, i.e., the number of days in each
class.
\item \code{sum.n} is the cumulative frequency, obtained by adding the absolute
frequencies of all the classes up to the one under consideration.
\item \code{P} is the pluviometric total of each class, obtained by multiplying
\code{midpoint} by \code{n}.
\item \code{sum.P} is the cummulative class's pluviometric total, obtained by
adding the pluviometric total of all the classes up to the one under consideration.
\item \code{p.sum.n} is the cumulative percentage of rainy days.
\item \code{p.sum.P} is the cumulative percentage of rainfall amounts.
}
}
\description{
Calculates the frequency distribution of a daily precipitation
serie based on \code{interval}.
}
\examples{
##
# Loading the daily precipitation serie
data(daily)

##
# Performing the frequency distribution
as.precintcon.fd(daily)
}
\author{
Lucas Venezian Povoa \email{lucasvenez@gmail.com}
}
\seealso{
\code{\link{read.data}}
\code{\link{as.daily}}
\code{\link{ci}}
}
\keyword{distribution}
\keyword{frequency}
\keyword{precipitation}

