% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_surv.R
\name{cox.rmst}
\alias{cox.rmst}
\title{Estimate restricted mean survival time (RMST) based on Cox regression model}
\usage{
cox.rmst(y, d, x.cate, xnew, tau0)
}
\arguments{
\item{y}{Observed survival or censoring time; vector of size \code{n}.}

\item{d}{The event indicator, normally \code{1 = event, 0 = censored}; vector of size \code{n}.}

\item{x.cate}{Matrix of \code{p.cate} baseline covariates specified in the outcome model; dimension \code{n} by \code{p.cate}.}

\item{xnew}{Matrix of \code{p.cate} baseline covariates for which we want an estimate of the RMST; dimension \code{m} (observations in the new data set) by \code{p.cate}}

\item{tau0}{The truncation time for defining restricted mean time lost.}
}
\value{
The estimated RMST for new subjects with covariates \code{xnew}; vector of size \code{m}.
}
\description{
Estimate restricted mean survival time (RMST) based on Cox regression model
}
