% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CATE_surv.R
\name{intxsurv}
\alias{intxsurv}
\title{Estimate the CATE model using specified scoring methods for survival outcomes}
\usage{
intxsurv(
  y,
  d,
  trt,
  x.cate,
  x.ps,
  x.ipcw,
  yf = NULL,
  tau0,
  surv.min = 0.025,
  score.method = c("randomForest", "boosting", "poisson", "twoReg", "contrastReg"),
  ps.method = "glm",
  minPS = 0.01,
  maxPS = 0.99,
  ipcw.method = "breslow",
  initial.predictor.method = "randomForest",
  tree.depth = 3,
  n.trees.rf = 1000,
  n.trees.boosting = 150,
  B = 3,
  Kfold = 5,
  plot.gbmperf = TRUE,
  error.maxNR = 0.001,
  max.iterNR = 100,
  tune = c(0.5, 2),
  ...
)
}
\arguments{
\item{y}{Observed survival or censoring time; vector of size \code{n}.}

\item{d}{The event indicator, normally \code{1 = event, 0 = censored}; vector of size \code{n}.}

\item{trt}{Treatment received; vector of size \code{n} with treatment coded as 0/1.}

\item{x.cate}{Matrix of \code{p.cate} baseline covariates specified in the outcome model; dimension \code{n} by \code{p.cate}.}

\item{x.ps}{Matrix of \code{p.ps} baseline covariates specified in the propensity score model; dimension \code{n} by \code{p.ps}.}

\item{x.ipcw}{Matrix of \code{p.ipw} baseline covariate specified in inverse probability of censoring weighting; dimension \code{n} by \code{p.ipw}.}

\item{yf}{Follow-up time, interpreted as the potential censoring time; vector of size \code{n} if the potential censoring time is known.}

\item{tau0}{The truncation time for defining restricted mean time lost.}

\item{surv.min}{Lower truncation limit for probability of being censored (positive and very close to 0).}

\item{score.method}{A vector of one or multiple methods to estimate the CATE score.
Allowed values are:  \code{'randomForest'}, \code{'boosting'}, \code{'poisson'}, \code{'twoReg'},
\code{'contrastReg'}. Default specifies all 5 methods.}

\item{ps.method}{A character vector for the method to estimate the propensity score.
Allowed values include one of:
\code{'glm'} for logistic regression with main effects only (default), or
\code{'lasso'} for a logistic regression with main effects and LASSO penalization on
two-way interactions (added to the model if interactions are not specified in \code{ps.model}).
Relevant only when \code{ps.model} has more than one variable.}

\item{minPS}{A numerical value (in [0, 1]) below which estimated propensity scores should be
truncated. Default is \code{0.01}.}

\item{maxPS}{A number above which estimated propensity scores should be trimmed; scalar}

\item{ipcw.method}{The censoring model. Allowed values are: \code{'breslow'} (Cox regression with Breslow estimator of the baseline survivor function),
\code{'aft (exponential)'}, \code{'aft (weibull)'}, \code{'aft (lognormal)'} or \code{'aft (loglogistic)'}. Default is \code{'breslow'}.}

\item{initial.predictor.method}{A character vector for the method used to get initial
outcome predictions conditional on the covariates in \code{cate.model}
in \code{score.method = 'twoReg'} and \code{'contrastReg'}. Allowed values include
one of \code{'randomForest'}, \code{'boosting'} and \code{'logistic'} (fastest). Default is \code{'randomForest'}.}

\item{tree.depth}{A positive integer specifying the depth of individual trees in boosting
(usually 2-3). Used only if \code{score.method = 'boosting'} or
if \code{score.method = 'twoReg'} or \code{'contrastReg'} and
\code{initial.predictor.method = 'boosting'}. Default is \code{3}.}

\item{n.trees.rf}{A positive integer specifying the maximum number of trees in random forest.
Used if \code{score.method = 'ranfomForest'} or
if \code{initial.predictor.method = 'randomForest'} with
\code{score.method = 'twoReg'} or \code{'contrastReg'}. Default is \code{1000}.}

\item{n.trees.boosting}{A positive integer specifying the maximum number of trees in boosting
(usually 100-1000). Used if \code{score.method = 'boosting'} or
if \code{initial.predictor.method = 'boosting'} with
\code{score.method = 'twoReg'} or \code{'contrastReg'}. Default is \code{150}.}

\item{B}{A positive integer specifying the number of time cross-fitting is repeated in
\code{score.method = 'twoReg'} and \code{'contrastReg'}. Default is \code{3}.}

\item{Kfold}{A positive integer specifying the number of folds (parts) used in cross-fitting
to partition the data in \code{score.method = 'twoReg'} and \code{'contrastReg'}.
Default is \code{5}.}

\item{plot.gbmperf}{A logical value indicating whether to plot the performance measures in
boosting. Used only if \code{score.method = 'boosting'} or if \code{score.method = 'twoReg'}
or \code{'contrastReg'} and \code{initial.predictor.method = 'boosting'}. Default is \code{TRUE}.}

\item{error.maxNR}{A numerical value > 0 indicating the minimum value of the mean absolute
error in Newton Raphson algorithm. Used only if \code{score.method = 'contrastReg'}.
Default is \code{0.001}.}

\item{max.iterNR}{A positive integer indicating the maximum number of iterations in the
Newton Raphson algorithm. Used only if \code{score.method = 'contrastReg'}.
Default is \code{100}.}

\item{tune}{A vector of 2 numerical values > 0 specifying tuning parameters for the
Newton Raphson algorithm. \code{tune[1]} is the step size, \code{tune[2]} specifies a
quantity to be added to diagonal of the slope matrix to prevent singularity.
Used only if \code{score.method = 'contrastReg'}. Default is \code{c(0.5, 2)}.}

\item{...}{Additional arguments for \code{gbm()}}
}
\value{
Depending on what score.method is, the outputs is a combination of the following:
          result.randomForest: Results of random forest fit, for trt = 0 and trt = 1 separately
          result.boosting: Results of boosting fit, for trt = 0 and trt = 1 separately
          result.poisson: Naive Poisson estimator (beta1 - beta0); vector of length \code{p.cate} + 1
          result.twoReg: Two regression estimator (beta1 - beta0); vector of length \code{p.cate} + 1
          result.contrastReg: A list of the contrast regression results with 2 elements:
              $delta.contrastReg: Contrast regression DR estimator; vector of length \code{p.cate} + 1
              $converge.contrastReg: Indicator that the Newton Raphson algorithm converged for \code{delta_0}; boolean
}
\description{
Coefficients of the CATE estimated with random forest, boosting, naive Poisson, two regression, and contrast regression
}
