% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_update.R
\name{pred_update}
\alias{pred_update}
\title{Perform Model Updating on an Existing Prediction Model}
\usage{
pred_update(
  x,
  update_type = c("intercept_update", "recalibration", "refit"),
  new_data,
  binary_outcome = NULL,
  survival_time = NULL,
  event_indicator = NULL
)
}
\arguments{
\item{x}{an object of class "\code{predinfo}" produced by calling
\code{\link{pred_input_info}} containing information on exactly one
existing prediction model.}

\item{update_type}{character variable specifying the level of updating that
is required.}

\item{new_data}{data.frame upon which the prediction models should be
updated.}

\item{binary_outcome}{Character variable giving the name of the column in
\code{new_data} that represents the observed binary outcomes (should be
coded 0 and 1 for non-event and event, respectively). Only relevant for
\code{model_type}="logistic"; leave as \code{NULL} otherwise. Leave as
\code{NULL} if \code{new_data} does not contain any outcomes.}

\item{survival_time}{Character variable giving the name of the column in
\code{new_data} that represents the observed survival times. Only relevant
for \code{x$model_type}="survival"; leave as \code{NULL} otherwise.}

\item{event_indicator}{Character variable giving the name of the column in
\code{new_data} that represents the observed survival indicator (1 for
event, 0 for censoring). Only relevant for \code{x$model_type}="survival";
leave as \code{NULL} otherwise.}
}
\value{
A object of class "\code{predUpdate}". This is the same as that
detailed in \code{\link{pred_input_info}}, with the added element
containing the estimates of the model updating and the update type.
}
\description{
This function takes an existing (previously developed) prediction model and
applies various model updating methods to tailor/adapt it to a new dataset.
Various levels of updating are possible, ranging from model re-calibration to
model refit.
}
\details{
This function takes a single existing (previously estimated)
prediction model, and apply various model discrete model updating methods
(see Su et al. 2018) to tailor the model to a new dataset.

The type of updating method is selected with the \code{update_type}
parameter, with options: "intercept_update", "recalibration" and "refit".
"intercept_update" corrects the overall calibration-in-the-large of the
model, through altering the model intercept (or baseline hazard) to suit
the new dataset. This is achieved by fitting a logistic model (if the
existing model is of type logistic) or time-to-event model (if the existing
model if of type survival) to the new dataset, with the linear predictor as
the only covariate, with the coefficient fixed at unity (i.e. as an
offset). "recalibration" corrects the calibration-in-the-large and any
under/over-fitting, by fitting a logistic model (if the existing model is
of type logistic) or time-to-event model (if the existing model if of type
survival) to the new dataset, with the linear predictor as the only
covariate. Finally, "refit" takes the original model structure and
re-estimates all coefficients; this has the effect as re-developing the
original model in the new data.

\code{new_data} should be a data.frame, where each row should be an
observation (e.g. patient) and each variable/column should be a predictor
variable. The predictor variables need to include (as a minimum) all of the
predictor variables that are included in the existing prediction model
(i.e., each of the variable names supplied to
\code{\link{pred_input_info}}, through the \code{model_info} parameter,
must match the name of a variables in \code{new_data}).

Any factor variables within \code{new_data} must be converted to dummy
(0/1) variables before calling this function. \code{\link{dummy_vars}} can
help with this. See \code{\link{pred_predict}} for examples.

\code{binary_outcome}, \code{survival_time} and \code{event_indicator} are
used to specify the outcome variable(s) within \code{new_data} (use
\code{binary_outcome} if \code{x$model_type} = "logistic", or use
\code{survival_time} and \code{event_indicator} if \code{x$model_type} =
"survival").
}
\examples{
#Example 1 - update time-to-event model by updating the baseline hazard in new dataset
model1 <- pred_input_info(model_type = "survival",
                          model_info = SYNPM$Existing_TTE_models[1,],
                          cum_hazard = SYNPM$TTE_mod1_baseline)
recalibrated_model1 <- pred_update(x = model1,
                                   update_type = "intercept_update",
                                   new_data = SYNPM$ValidationData,
                                   survival_time = "ETime",
                                   event_indicator = "Status")
summary(recalibrated_model1)

}
\references{
Su TL, Jaki T, Hickey GL, Buchan I, Sperrin M. A review of
statistical updating methods for clinical prediction models. \emph{Stat Methods
Med Res}. 2018 Jan;27(1):185-197. doi: 10.1177/0962280215626466.
}
\seealso{
\code{\link{pred_input_info}}
}
