% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep.R
\name{prep.detrend.sfsm}
\alias{prep.detrend.sfsm}
\title{Detrend with "substracting full-season means" method}
\usage{
prep.detrend.sfsm(tserie)
}
\arguments{
\item{tserie}{a \code{ts} object}
}
\value{
A list is returned containing:
\item{tserie}{Transformed ts object.}
\item{means}{Vector containing the historical means.}
}
\description{
Performs "substracting full-season means" method to go for a totally automatic
approach.
}
\details{
Under this detrending scheme, a series is first split into segments. The length
of the segments is equal to the length of seasonality(12 for monthly).
The mean of the historical observations within each of these segments is substacted
from every historical observation in the segment.
To get the detrended serie we do:
\code{ds = xi - m}
Being \code{xi} the actual values on the time series and \code{m} the mean of the segment of \code{xi}
}
\examples{
prep.detrend.sfsm(AirPassengers)
}
