% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prereg_justify.R
\name{prereg_justify}
\alias{prereg_justify}
\title{Justify (and optionally specify) the content for one or more (pre)registration items}
\usage{
prereg_justify(
  x,
  item,
  decision = NULL,
  justification = NULL,
  assertion = NULL,
  source = NULL,
  content = NULL,
  append = TRUE,
  validate = TRUE,
  requireValidContent = TRUE,
  silent = preregr::opts$get("silent")
)
}
\arguments{
\item{x}{The (pre)registration object (as produced by a call to
\code{\link[=prereg_initialize]{prereg_initialize()}}).}

\item{item}{The identifier of the item for which to specify the justification
of the (pre)registration content.}

\item{decision, justification, assertion, source}{The decision(s) (with
optionally nested within it, one or more justifications), justification(s)
(with optionally nested within it, one or more assertions), assertion(s)
(with optionally nested within it, one or more sources), or source(s).}

\item{content}{Optionally, content to specify or append for this item.}

\item{append}{Whether to replace (\code{append=FALSE}) or append (\code{append=TRUE})
the content if an item already contains some content.}

\item{validate}{Whether to validate the specified content for each item
using the validation rules in the (pre)registration form.}

\item{requireValidContent}{Whether to only store new content if it passes
validation. Note that this is ignored if \code{validate=FALSE}.}

\item{silent}{Whether to be silent or chatty.}
}
\value{
x, invisibly
}
\description{
Justify (and optionally specify) the content for one or more (pre)registration items
}
\examples{
preregExampl <-
preregr::prereg_initialize(
  "inclSysRev_v0_92"
) |>
  preregr::prereg_justify(
    item = "title",
    content = "Example title",
    decision = "We decide to call this study 'Example title'.",
    justification = "It seems a fitting title for an example."
  ) |>
  preregr::prereg_show_item_completion(
    section="metadata"
  );
}
