% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{check_truncation}
\alias{check_truncation}
\title{Check if truncation time is appropriate relative to the maximum delay}
\usage{
check_truncation(delays, D, multiplier = 2)
}
\arguments{
\item{delays}{A numeric vector of delay times}

\item{D}{The truncation time}

\item{multiplier}{The multiplier for the maximum delay to compare with D.
Default is 2.}
}
\value{
Invisible NULL. Prints a message if the condition is met.
}
\description{
This function checks if the truncation time D is appropriate relative to the
maximum delay. If D is much larger than necessary, it suggests
considering setting it to \code{Inf} for better efficiency with minimal accuracy
cost.
}
\examples{
check_truncation(delays = c(1, 2, 3, 4), D = 10, multiplier = 2)
}
\seealso{
Distribution checking functions
\code{\link{check_dprimary}()},
\code{\link{check_pdist}()}
}
\concept{check}
