## ---- include = FALSE----------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>"
)

## ----setup---------------------------------------------------------------
library(prioGene)
#One-step interactions with known
#disease-causing genes are retained in networks
net_disease <- deal_net(net,dise_gene)

#Get a one-to-many matrix of gene and GO term
genes_mat <- get_gene_mat(net_disease,GO_human)
#Get a one-to-many matrix of GO term and gene
terms_mat <- get_term_mat(net_disease,GO_human)
#Get the GO term for each pair of nodes in the network
net_disease_term <- get_net_disease_term(genes_mat,net_disease)
#weighting gene
node_weight <- get_node_weight(genes_mat)
#weighting edge
edge_weight <- get_edge_weight(net_disease_term)
#Q is the disease risk transition probability matrix,
#which is composed of transition probabilities from one gene to another
Q <- get_Q()
#R—_0 is the vector of initial disease risk scores for all genes
R_0<- get_R_0(dise_gene,node_weight,f=1)
#get the result the output number is the number of iterations
result <- get_R(Q,0.5,R_0,node_weight,10^(-9))

