% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getModelInfo.R
\name{getModelInfo}
\alias{getModelInfo}
\title{Extract general information about mathematical model}
\usage{
getModelInfo(x)
}
\arguments{
\item{x}{\linkS4class{optimizationProblem}, \linkS4class{solution} or \linkS4class{portfolio} object.}
}
\value{
\link{data.frame}.
}
\description{
Provides general information about the mathematical model.
}
\details{
\code{getModelInfo()} function returns five specific fields:
\enumerate{
\item \strong{solution_name}: indicates the name of the solution, by default is \emph{sol}.
\item \strong{model_sense}: returns the optimization sense (i.e., it indicates whether the
objective function is minimized or maximize).
\item \strong{n_constraints}: returns the number of constraints in the corresponding
mathematical optimization model.
\item \strong{n_variables}: returns the number of variables in the corresponding
mathematical optimization model.
\item \strong{size}: returns the size of the constraints' coefficients matrix A
number of constraints and number of variables).
}
}
\examples{
# set seed for reproducibility
set.seed(14)

## Load data
data(sim_pu_data, sim_features_data, sim_dist_features_data,
sim_threats_data, sim_dist_threats_data, sim_sensitivity_data,
sim_boundary_data)

## Create data instance
problem_data <- inputData(
  pu = sim_pu_data, features = sim_features_data, dist_features = sim_dist_features_data,
  threats = sim_threats_data, dist_threats = sim_dist_threats_data,
  sensitivity = sim_sensitivity_data, boundary = sim_boundary_data
)

## Create optimization model
problem_model <- problem(x = problem_data, blm = 1)

# get model information
getModelInfo(problem_model)

}
