% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getConnectivityPenalty.R
\name{getConnectivityPenalty}
\alias{getConnectivityPenalty}
\title{Extract connectivity penalty values}
\usage{
getConnectivityPenalty(x)
}
\arguments{
\item{x}{\linkS4class{solution} or \linkS4class{portfolio} object.}
}
\value{
\link{data.frame}.
}
\description{
Provides the connectivity penalty value for all actions and planning units in a solution.
}
\details{
The connectivity penalty among is calculated as the sum of all
connectivity penalties by each action and planning unit in the solution. This can be expressed
mathematically for a set of planning units
\eqn{I} indexed by \eqn{i} and \eqn{j}, and
a set of threats \eqn{K} indexed by \eqn{k} as:

\deqn{
\sum_{k \in K}\sum_{i \in I_k}\sum_{j \in I_k} x_{ik} (1 - x_{jk})cv_{ij}
}

Where, \eqn{x_{ik}} is the decisions variable that specify
whether an action has been selected to abate threat \eqn{k} in planning unit
\eqn{i} (1) or not (0), \eqn{cv_{ij}} is the connectivity penalty that applies
when a solution contains planning unit \eqn{i} but not \eqn{j} o viceversa.

Note that there is an action per threat, so it is assumed that the index of
the threat coincides with the index of the action used to abate it.
}
\examples{
\donttest{
# set seed for reproducibility
set.seed(14)

## Load data
data(sim_pu_data, sim_features_data, sim_dist_features_data,
sim_threats_data, sim_dist_threats_data, sim_sensitivity_data,
sim_boundary_data)

## Create data instance
problem_data <- inputData(
  pu = sim_pu_data, features = sim_features_data, dist_features = sim_dist_features_data,
  threats = sim_threats_data, dist_threats = sim_dist_threats_data,
  sensitivity = sim_sensitivity_data, boundary = sim_boundary_data
)

## Create optimization model
problem_model <- problem(x = problem_data, blm = 0.03)

## Solve the optimization model
s <- solve(a = problem_model, time_limit = 2, output_file = FALSE, cores = 2)

# get connectivity penalty values
getConnectivityPenalty(s)
}

}
