% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Parameters-proto.R
\name{Parameters-class}
\alias{Parameters-class}
\alias{Parameters}
\title{Parameters class}
\description{
This class represents a collection of \code{\linkS4class{Parameter}} objects.
It provides methods for accessing and updating the parameters
stored inside it.
}
\section{Fields}{

\describe{

\item{$parameters}{\code{list} object containing
\code{\linkS4class{Parameter}} objects.}

}
}

\section{Usage}{


\code{x$print()}

\code{x$show()}

\code{x$repr()}

\code{x$names()}

\code{x$ids()}

\code{x$length()}

\code{x$get(id)}

\code{x$set(id, value)}

\code{x$add(p)}
}

\section{Arguments}{

\describe{
\item{id}{\code{\link{Id}} object.}

\item{p}{\code{\linkS4class{Parameter}} object.}

\item{value}{any object.}

}
}

\section{Details}{


\describe{

\item{print}{print the object.}

\item{show}{show the object.}

\item{repr}{\code{character} representation of object.}

\item{names}{return \code{character} names of parameters.}

\item{ids}{return \code{character} parameter unique identifiers.}

\item{length}{return \code{integer} number of parameters in object.}
\item{get}{retrieve the value of a parameter in the object
using an \code{Id} object.}

\item{set}{change the value of a parameter in the object
to a new object.}

}
}

